/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.tbasic.runtime.debug;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.openl.rules.table.IGridRegion;
import org.openl.rules.tbasic.runtime.Result;
import org.openl.rules.tbasic.runtime.debug.ATBasicTraceObjectLeaf;
import org.openl.rules.tbasic.runtime.operations.RuntimeOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TBasicOperationTraceObject
extends ATBasicTraceObjectLeaf {
    private Result result;
    private HashMap<String, Object> fieldValues;

    public TBasicOperationTraceObject(Object tracedObject) {
        super(tracedObject);
    }

    public String getDisplayName(int mode) {
        RuntimeOperation operation = (RuntimeOperation)this.getTraceObject();
        String operationName = operation.getSourceCode().getOperationName();
        String stepNameForDebug = operation.getNameForDebug() != null ? operation.getNameForDebug() : "";
        String resultValue = "";
        if (this.result != null && this.result.getValue() != null) {
            resultValue = "(" + this.result.getValue().toString() + ")";
        }
        int operationRow = operation.getSourceCode().getRowNumber();
        String fieldFormatedValues = this.getFieldValuesAsString();
        String displayFieldFormatedValues = "";
        if (!fieldFormatedValues.equals("")) {
            displayFieldFormatedValues = String.format("[Local vars: %s]", fieldFormatedValues);
        }
        return String.format("Step: row %d: %s %s %s %s", operationRow, operationName, stepNameForDebug, resultValue, displayFieldFormatedValues);
    }

    public HashMap<String, Object> getFieldValues() {
        return this.fieldValues;
    }

    private String getFieldValuesAsString() {
        StringBuffer fields = new StringBuffer();
        for (String fieldName : this.fieldValues.keySet()) {
            fields.append(fieldName).append(" = ").append(this.fieldValues.get(fieldName)).append(", ");
        }
        if (fields.length() > 2) {
            fields.delete(fields.length() - 2, fields.length());
        }
        return fields.toString();
    }

    @Override
    public List<IGridRegion> getGridRegions() {
        ArrayList<IGridRegion> regions = new ArrayList<IGridRegion>();
        RuntimeOperation operation = (RuntimeOperation)this.getTraceObject();
        regions.add(operation.getSourceCode().getGridRegion());
        return regions;
    }

    public Result getResult() {
        return this.result;
    }

    public String getType() {
        return "tbasicOperation";
    }

    public String getUri() {
        RuntimeOperation operation = (RuntimeOperation)this.getTraceObject();
        String operationUri = operation.getSourceCode().getSourceUri();
        return operationUri;
    }

    public void setFieldValues(HashMap<String, Object> fieldValues) {
        this.fieldValues = (HashMap)fieldValues.clone();
    }

    public void setResult(Result result) {
        this.result = result;
    }
}

