/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.tbasic.runtime.operations;

import java.util.HashMap;
import org.openl.rules.tbasic.compile.AlgorithmOperationSource;
import org.openl.rules.tbasic.runtime.Result;
import org.openl.rules.tbasic.runtime.TBasicContextHolderEnv;
import org.openl.rules.tbasic.runtime.debug.TBasicOperationTraceObject;
import org.openl.vm.trace.ITracerObject;
import org.openl.vm.trace.Tracer;

public abstract class RuntimeOperation {
    private AlgorithmOperationSource sourceCode;
    private boolean significantForDebug;
    private String nameForDebug;

    public abstract Result execute(TBasicContextHolderEnv var1, Object var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result execute(TBasicContextHolderEnv environment, Object param, boolean debugMode) {
        Result result = null;
        TBasicOperationTraceObject operationTracer = null;
        if (debugMode && this.significantForDebug) {
            operationTracer = new TBasicOperationTraceObject(this);
            operationTracer.setFieldValues((HashMap)environment.getTbasicTarget().getFieldValues());
            Tracer.getTracer().push((ITracerObject)operationTracer);
        }
        try {
            result = this.execute(environment, param);
        }
        finally {
            if (debugMode && this.significantForDebug) {
                operationTracer.setResult(result);
                Tracer.getTracer().pop();
            }
        }
        return result;
    }

    public String getNameForDebug() {
        return this.nameForDebug;
    }

    public AlgorithmOperationSource getSourceCode() {
        return this.sourceCode;
    }

    public boolean isSignificantForDebug() {
        return this.significantForDebug;
    }

    public void setNameForDebug(String nameForDebug) {
        this.nameForDebug = nameForDebug;
    }

    public void setSignificantForDebug(boolean significantForDebug) {
        this.significantForDebug = significantForDebug;
    }

    public void setSourceCode(AlgorithmOperationSource sourceCode) {
        this.sourceCode = sourceCode;
    }
}

