/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.testmethod;

import java.util.ArrayList;
import java.util.List;
import org.openl.main.OpenLWrapper;
import org.openl.rules.testmethod.TestSuiteMethod;
import org.openl.rules.testmethod.TestUnitsResults;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;
import org.openl.util.Log;
import org.openl.util.RuntimeExceptionWrapper;
import org.openl.vm.IRuntimeEnv;
import org.openl.vm.SimpleVM;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestAll {
    public TestStatistics testAllWrapper(Class<? extends OpenLWrapper> c) {
        OpenLWrapper engine;
        long start = System.currentTimeMillis();
        try {
            engine = c.newInstance();
        }
        catch (Throwable t) {
            throw RuntimeExceptionWrapper.wrap((Throwable)t);
        }
        long end = System.currentTimeMillis();
        IOpenClass ioc = engine.getOpenClass();
        return this.runAllTests(ioc, new TestStatistics(ioc.getName(), end - start));
    }

    public TestStatistics testAll(IOpenClass ioc) {
        TestStatistics stat = new TestStatistics(ioc.getName(), -1L);
        return this.runAllTests(ioc, stat);
    }

    private TestStatistics runAllTests(IOpenClass ioc, TestStatistics stat) {
        IRuntimeEnv env = new SimpleVM().getRuntimeEnv();
        stat.setStart(System.currentTimeMillis());
        for (IOpenMethod m : ioc.getMethods()) {
            if (m.getType().getInstanceClass() != TestUnitsResults.class) continue;
            this.runTestMethod(m, ioc.newInstance(env), env, stat);
        }
        stat.setEnd(System.currentTimeMillis());
        return stat;
    }

    protected void runTestMethod(IOpenMethod testMethod, Object engine, IRuntimeEnv env, TestStatistics stat) {
        TestUnitsResults res = (TestUnitsResults)testMethod.invoke(engine, new Object[0], env);
        if (!(testMethod instanceof TestSuiteMethod)) {
            return;
        }
        if (!((TestSuiteMethod)testMethod).isRunmethodTestable()) {
            return;
        }
        Log.info((Object)("Testing " + testMethod.getName() + ", tests: " + res.getNumberOfTestUnits() + ", failures:" + res.getNumberOfFailures()));
        stat.addTestResult(res);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TestStatistics {
        private long start;
        private long end;
        private long loadTimeMs = -1L;
        private ArrayList<TestUnitsResults> results = new ArrayList();
        String name;

        public TestStatistics(String name, long loadTimeMs) {
            this.name = name;
            this.loadTimeMs = loadTimeMs;
        }

        public void addTestResult(TestUnitsResults res) {
            this.results.add(res);
        }

        public int getNumberOfFailedTests() {
            int sum = 0;
            for (TestUnitsResults tres : this.results) {
                if (tres.getNumberOfFailures() <= 0) continue;
                ++sum;
            }
            return sum;
        }

        public List<TestUnitsResults> getFilteredResults(boolean includePassedTests, boolean orderFailedFirst) {
            List list = (List)this.results.clone();
            return list;
        }

        public long getStart() {
            return this.start;
        }

        public void setStart(long start) {
            this.start = start;
        }

        public long getEnd() {
            return this.end;
        }

        public void setEnd(long end) {
            this.end = end;
        }

        public List<TestUnitsResults> getResults() {
            return this.results;
        }

        public String toString() {
            return "Loaded " + this.name + " in " + this.loadTimeMs + "ms\n" + "Executed/failed tests: " + this.results.size() + "/" + this.getNumberOfFailedTests() + " in " + (this.end - this.start) + " ms";
        }

        public String printFailedResults() {
            StringBuilder sb = new StringBuilder(1000);
            sb.append(this.toString());
            for (TestUnitsResults test : this.results) {
                if (test.getNumberOfFailures() <= 0) continue;
                sb.append('\n').append(test);
            }
            return sb.toString();
        }

        public long getLoadTimeMs() {
            return this.loadTimeMs;
        }

        public void setLoadTimeMs(long loadTimeMs) {
            this.loadTimeMs = loadTimeMs;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

