/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.testmethod;

import java.util.Map;
import org.openl.binding.BindingDependencies;
import org.openl.rules.lang.xls.XlsNodeTypes;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.table.xls.formatters.FormattersManager;
import org.openl.rules.testmethod.TestMethodBoundNode;
import org.openl.rules.testmethod.TestMethodHelper;
import org.openl.rules.testmethod.TestMethodOpenClass;
import org.openl.rules.testmethod.TestUnitsResults;
import org.openl.runtime.IRuntimeContext;
import org.openl.types.IMemberMetaInfo;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMethod;
import org.openl.types.impl.AMethod;
import org.openl.types.impl.DynamicObject;
import org.openl.types.impl.IBenchmarkableMethod;
import org.openl.util.Log;
import org.openl.util.formatters.IFormatter;
import org.openl.vm.IRuntimeEnv;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestSuiteMethod
extends AMethod
implements IMemberMetaInfo,
IBenchmarkableMethod {
    private String tableName;
    private IOpenMethod testedMethod;
    private TestMethodBoundNode boundNode;
    private IOpenClass methodBasedClass;
    private Map<String, Object> properties;

    public TestSuiteMethod(String tableName, IOpenMethod testedMethod, TestMethodBoundNode boundNode) {
        super(TestMethodHelper.makeHeader(tableName, testedMethod));
        this.tableName = tableName;
        this.testedMethod = testedMethod;
        this.boundNode = boundNode;
        this.properties = this.getSyntaxNode().getTableProperties().getAllProperties();
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public TestMethodBoundNode getBoundNode() {
        return this.boundNode;
    }

    public void setBoundNode(TestMethodBoundNode boundNode) {
        this.boundNode = boundNode;
    }

    public String[] unitName() {
        return new String[]{"Test Unit", "Test Units"};
    }

    public String getBenchmarkName() {
        return "Test " + this.testedMethod.getName();
    }

    public BindingDependencies getDependencies() {
        return new BindingDependencies();
    }

    public IMemberMetaInfo getInfo() {
        return this;
    }

    public int getNumberOfTests() {
        Object testArray = this.boundNode.getField().getData();
        DynamicObject[] dd = (DynamicObject[])testArray;
        return dd.length;
    }

    public String getSourceUrl() {
        return this.getSyntaxNode().getUri();
    }

    public TableSyntaxNode getSyntaxNode() {
        return this.boundNode.getTableSyntaxNode();
    }

    public String[] getTestDescriptions() {
        Object testArray = this.boundNode.getField().getData();
        DynamicObject[] dd = (DynamicObject[])testArray;
        String[] descriptions = new String[dd.length];
        for (int i = 0; i < descriptions.length; ++i) {
            String description = (String)dd[i].getFieldValue("_description_");
            if (description == null) {
                if (this.testedMethod.getSignature().getNumberOfParameters() > 0) {
                    String name = this.testedMethod.getSignature().getParameterName(0);
                    Object value = dd[i].getFieldValue(name);
                    IFormatter formatter = FormattersManager.getFormatter(value);
                    description = formatter.format(value);
                } else {
                    description = "Run with no parameters";
                }
            }
            descriptions[i] = description;
        }
        return descriptions;
    }

    public String getColumnDisplayName(String columnTechnicalName) {
        int columnIndex = this.boundNode.getTable().getColumnIndex(columnTechnicalName);
        if (columnIndex >= 0) {
            return this.boundNode.getTable().getColumnDisplay(columnIndex);
        }
        return null;
    }

    public synchronized IOpenClass getMethodBasedClass() {
        if (this.methodBasedClass == null) {
            this.methodBasedClass = new TestMethodOpenClass(this.tableName, this.testedMethod);
        }
        return this.methodBasedClass;
    }

    public IOpenMethod getTestedMethod() {
        return this.testedMethod;
    }

    public Object invoke(Object target, Object[] params, IRuntimeEnv env) {
        return this.invoke(target, params, env, -1);
    }

    public Object invoke(Object target, Object[] params, IRuntimeEnv env, int unitId) {
        return this.invokeBenchmark(target, params, env, 1, unitId);
    }

    public Object invokeBenchmark(Object target, Object[] params, IRuntimeEnv env, int ntimes) {
        return this.invokeBenchmark(target, params, env, ntimes, -1);
    }

    public Object invokeBenchmark(Object target, Object[] params, IRuntimeEnv env, int ntimes, int unitId) {
        Object testArray = this.boundNode.getField().get(target, env);
        DynamicObject[] testInstances = (DynamicObject[])testArray;
        IOpenClass dclass = this.getMethodBasedClass();
        IMethodSignature msign = this.testedMethod.getSignature();
        IOpenClass[] mpars = msign.getParameterTypes();
        TestUnitsResults tres = new TestUnitsResults(this);
        int unitStart = unitId > -1 ? unitId : 0;
        int unitStop = unitId > -1 ? unitStart + 1 : testInstances.length;
        for (int i = unitStart; i < unitStop; ++i) {
            Object[] mpvals = new Object[mpars.length];
            DynamicObject currentTest = testInstances[i];
            for (int j = 0; j < mpars.length; ++j) {
                IOpenField f = dclass.getField(msign.getParameterName(j), true);
                mpvals[j] = f.get((Object)currentTest, env);
            }
            try {
                Object res = null;
                for (int j = 0; j < ntimes; ++j) {
                    IOpenField contextField = dclass.getField("_context_");
                    IRuntimeContext context = (IRuntimeContext)contextField.get((Object)currentTest, env);
                    IRuntimeContext oldContext = env.getContext();
                    env.setContext(context);
                    res = this.testedMethod.invoke(target, mpvals, env);
                    env.setContext(oldContext);
                }
                tres.addTestUnit(currentTest, res, null);
                continue;
            }
            catch (Throwable t) {
                Log.error((Object)("Testing " + currentTest), (Throwable)t);
                tres.addTestUnit(currentTest, null, t);
            }
        }
        return tres;
    }

    public boolean isRunmethod() {
        TableSyntaxNode tsn = this.getSyntaxNode();
        return XlsNodeTypes.XLS_RUN_METHOD.toString().equals(tsn.getType());
    }

    public boolean isRunmethodTestable() {
        Object testArray = this.boundNode.getField().getData();
        DynamicObject[] testArrayDynamicObj = (DynamicObject[])testArray;
        for (int i = 0; i < testArrayDynamicObj.length; ++i) {
            if (!testArrayDynamicObj[i].containsField("_res_") && !testArrayDynamicObj[i].containsField("_error_")) continue;
            return true;
        }
        return false;
    }

    public int nUnitRuns() {
        return this.getNumberOfTests();
    }

    public Object run(int tid, Object target, IRuntimeEnv env, int ntimes) {
        Object testArray = this.boundNode.getField().get(target, env);
        DynamicObject[] dd = (DynamicObject[])testArray;
        IOpenClass dclass = this.getMethodBasedClass();
        IMethodSignature msign = this.testedMethod.getSignature();
        IOpenClass[] mpars = msign.getParameterTypes();
        DynamicObject currentTest = dd[tid];
        Object[] mpvals = new Object[mpars.length];
        for (int j = 0; j < mpars.length; ++j) {
            IOpenField f = dclass.getField(msign.getParameterName(j), true);
            mpvals[j] = f.get((Object)currentTest, env);
        }
        Object res = null;
        for (int i = 0; i < ntimes; ++i) {
            IOpenField contextField = dclass.getField("_context_");
            IRuntimeContext context = (IRuntimeContext)contextField.get((Object)currentTest, env);
            IRuntimeContext oldContext = env.getContext();
            env.setContext(context);
            res = this.testedMethod.invoke(target, mpvals, env);
            env.setContext(oldContext);
        }
        return res;
    }
}

