/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.testmethod;

import org.openl.meta.DoubleValue;
import org.openl.rules.helpers.NumberUtils;
import org.openl.rules.testmethod.TestUnitResultComparator;
import org.openl.types.impl.DynamicObject;

public class TestUnit {
    private DynamicObject testObj;
    private Object runningResult;
    private Throwable exception;
    private Object expectedResult;
    private Object actualResult;
    public static final String DEFAULT_DESCRIPTION = "No Description";

    public TestUnit(DynamicObject obj, Object res, Throwable exception) {
        this.exception = exception;
        this.runningResult = res;
        this.testObj = obj;
    }

    private void initExpectedResult() {
        this.expectedResult = this.exception != null ? this.getFieldValue("_error_") : this.getFieldValue("_res_");
    }

    private void initActualResult() {
        if (this.exception != null) {
            this.actualResult = this.exception;
            return;
        }
        if (NumberUtils.isFloatPointNumber(this.runningResult) && TestUnitResultComparator.compareResult(this.runningResult, this.getExpectedResult())) {
            Double result = NumberUtils.convertToDouble(this.runningResult);
            Double expectedResult = NumberUtils.convertToDouble(this.getExpectedResult());
            int scale = NumberUtils.getScale(expectedResult);
            Double roundedResult = NumberUtils.roundValue(result, scale);
            if (DoubleValue.class.isAssignableFrom(this.runningResult.getClass())) {
                ((DoubleValue)this.runningResult).setValue(roundedResult.doubleValue());
                this.actualResult = this.runningResult;
                return;
            }
            this.actualResult = roundedResult;
            return;
        }
        this.actualResult = this.runningResult;
    }

    public Object getExpectedResult() {
        if (this.expectedResult == null) {
            this.initExpectedResult();
        }
        return this.expectedResult;
    }

    public Object getActualResult() {
        if (this.actualResult == null) {
            this.initActualResult();
        }
        return this.actualResult;
    }

    public Object getDescription() {
        Object descr = this.getFieldValue("_description_");
        return descr == null ? DEFAULT_DESCRIPTION : descr;
    }

    public int compareResult() {
        return TestUnitResultComparator.getCompareResult(this);
    }

    public Object getFieldValue(String fieldName) {
        return this.testObj.getFieldValue(fieldName);
    }
}

