/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.testmethod;

import java.lang.reflect.Array;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.openl.rules.helpers.NumberUtils;
import org.openl.rules.testmethod.OpenLUserRuntimeException;
import org.openl.rules.testmethod.TestUnit;
import org.openl.util.math.MathUtils;

public class TestUnitResultComparator {
    public static final int TR_EXCEPTION = 2;
    public static final int TR_NEQ = 1;
    public static final int TR_OK = 0;

    private TestUnitResultComparator() {
    }

    public static int getCompareResult(TestUnit testUnit) {
        if (testUnit.getActualResult() instanceof Throwable) {
            return TestUnitResultComparator.compareExceptionResult(testUnit);
        }
        if (TestUnitResultComparator.compareResult(testUnit.getActualResult(), testUnit.getExpectedResult())) {
            return 0;
        }
        return 1;
    }

    private static int compareExceptionResult(TestUnit testUnit) {
        Throwable rootCause = ExceptionUtils.getRootCause((Throwable)((Throwable)testUnit.getActualResult()));
        if (rootCause instanceof OpenLUserRuntimeException) {
            String message = rootCause.getMessage();
            String expectedMessage = (String)testUnit.getExpectedResult();
            if (expectedMessage == null) {
                expectedMessage = "";
            }
            if (TestUnitResultComparator.compareResult(message, expectedMessage)) {
                return 0;
            }
            return 1;
        }
        return 2;
    }

    public static boolean compareResult(Object res, Object expected) {
        if (res == expected) {
            return true;
        }
        if (res == null || expected == null) {
            return false;
        }
        if (NumberUtils.isFloatPointNumber(res)) {
            Double result = NumberUtils.convertToDouble(res);
            Double expectedResult = NumberUtils.convertToDouble(expected);
            return MathUtils.eq((double)result, (double)expectedResult);
        }
        if (res instanceof Comparable) {
            return ((Comparable)res).compareTo(expected) == 0;
        }
        if (res.equals(expected)) {
            return true;
        }
        if (res.getClass().isArray() && expected.getClass().isArray()) {
            return TestUnitResultComparator.compareArrays(res, expected);
        }
        return false;
    }

    private static boolean compareArrays(Object res, Object expected) {
        int len = Array.getLength(res);
        if (len != Array.getLength(expected)) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (TestUnitResultComparator.compareResult(Array.get(res, i), Array.get(expected, i))) continue;
            return false;
        }
        return true;
    }
}

