/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.testmethod;

import java.util.ArrayList;
import org.openl.base.INamedThing;
import org.openl.rules.testmethod.TestSuiteMethod;
import org.openl.rules.testmethod.TestUnit;
import org.openl.types.IMethodSignature;
import org.openl.types.impl.DynamicObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestUnitsResults
implements INamedThing {
    private TestSuiteMethod testSuite;
    private ArrayList<TestUnit> testUnits = new ArrayList();

    public TestUnitsResults(TestSuiteMethod testSuite) {
        this.testSuite = testSuite;
    }

    public String getName() {
        return this.testSuite.getDisplayName(0);
    }

    public String getDisplayName(int mode) {
        return this.testSuite.getDisplayName(mode);
    }

    public ArrayList<TestUnit> getTestUnits() {
        return this.testUnits;
    }

    public void addTestUnit(DynamicObject testObj, Object res, Throwable ex) {
        TestUnit testUnit = new TestUnit(testObj, res, ex);
        this.testUnits.add(testUnit);
    }

    @Deprecated
    public Object getExpected(int i) {
        return this.testUnits.get(i).getExpectedResult();
    }

    public int getNumberOfFailures() {
        int cnt = 0;
        for (int i = 0; i < this.getNumberOfTestUnits(); ++i) {
            if (this.testUnits.get(i).compareResult() == 0) continue;
            ++cnt;
        }
        return cnt;
    }

    public int getNumberOfTestUnits() {
        return this.testUnits.size();
    }

    public boolean isAnyUnitHasDescription() {
        for (TestUnit testUnit : this.testUnits) {
            if (testUnit.getDescription().equals("No Description")) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public Object getUnitResult(int i) {
        return this.testUnits.get(i).getActualResult();
    }

    @Deprecated
    public Object getUnitDescription(int i) {
        return this.testUnits.get(i).getDescription();
    }

    public String[] getTestDataColumnDisplayNames() {
        String[] columnTechnicalNames = this.getTestDataColumnHeaders();
        String[] columnDisplayNames = new String[columnTechnicalNames.length];
        for (int i = 0; i < columnDisplayNames.length; ++i) {
            columnDisplayNames[i] = this.testSuite.getColumnDisplayName(columnTechnicalNames[i]);
        }
        return columnDisplayNames;
    }

    public String[] getTestDataColumnHeaders() {
        IMethodSignature testMethodSignature = this.testSuite.getTestedMethod().getSignature();
        int len = testMethodSignature.getParameterTypes().length;
        String[] res = new String[len];
        for (int i = 0; i < len; ++i) {
            res[i] = testMethodSignature.getParameterName(i);
        }
        return res;
    }

    @Deprecated
    public Object getTestValue(String fname, int i) {
        TestUnit testUnit = this.testUnits.get(i);
        return testUnit.getFieldValue(fname);
    }

    public StringBuilder printFailedUnits(StringBuilder sb) {
        sb.append(this.getName());
        if (this.getNumberOfFailures() == 0) {
            return sb.append(" - ").append(this.getNumberOfTestUnits()).append(" tests ALL OK!");
        }
        sb.append(" - ").append(this.getNumberOfTestUnits()).append(" tests / ").append(this.getNumberOfFailures()).append(" FAILED!");
        for (int i = 0; i < this.getNumberOfTestUnits(); ++i) {
            if (this.testUnits.get(i).compareResult() == 0) continue;
            sb.append('\n').append(i + 1).append(". ").append(this.testUnits.get(i).getDescription()).append("\t").append(this.testUnits.get(i).getExpectedResult()).append(" / ").append(this.testUnits.get(i).getActualResult());
        }
        return sb;
    }

    public String toString() {
        return this.printFailedUnits(new StringBuilder()).toString();
    }
}

