/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.types;

import java.util.ArrayList;
import java.util.List;
import org.openl.binding.MethodUtil;
import org.openl.rules.context.DefaultRulesRuntimeContext;
import org.openl.runtime.IRuntimeContext;
import org.openl.types.IMemberMetaInfo;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;
import org.openl.types.impl.MethodKey;
import org.openl.vm.IRuntimeEnv;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OpenMethodDispatcher
implements IOpenMethod {
    private IOpenMethod delegate;
    private MethodKey delegateKey;
    private List<IOpenMethod> candidates = new ArrayList<IOpenMethod>();

    protected void decorate(IOpenMethod delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException("Method cannot be null");
        }
        this.delegate = delegate;
        this.delegateKey = new MethodKey(delegate);
        this.candidates.add(delegate);
    }

    public IMethodSignature getSignature() {
        return this.delegate.getSignature();
    }

    public IOpenClass getDeclaringClass() {
        return this.delegate.getDeclaringClass();
    }

    public IMemberMetaInfo getInfo() {
        return null;
    }

    public IOpenClass getType() {
        return this.delegate.getType();
    }

    public boolean isStatic() {
        return this.delegate.isStatic();
    }

    public String getDisplayName(int mode) {
        return this.delegate.getDisplayName(mode);
    }

    public String getName() {
        return this.delegate.getName();
    }

    public IOpenMethod getMethod() {
        return this;
    }

    public List<IOpenMethod> getCandidates() {
        return this.candidates;
    }

    public Object invoke(Object target, Object[] params, IRuntimeEnv env) {
        IOpenMethod method;
        IRuntimeContext context = env.getContext();
        if (context == null) {
            context = new DefaultRulesRuntimeContext();
        }
        if ((method = this.findMatchingMethod(this.candidates, context)) == null) {
            StringBuffer sb = new StringBuffer();
            sb.append("Method signature: ");
            MethodUtil.printMethod((String)this.getName(), (IMethodSignature)this.getSignature(), (StringBuffer)sb);
            sb.append("\n");
            sb.append("Context: ");
            sb.append(context.toString());
            String message = String.format("Appropriate overloaded method for '%1$s' not found. Details: \n%2$s", this.getName(), sb.toString());
            throw new RuntimeException(message);
        }
        return method.invoke(target, params, env);
    }

    public void addMethod(IOpenMethod candidate) {
        MethodKey candidateKey = new MethodKey(candidate);
        if (!this.delegateKey.equals((Object)candidateKey)) {
            StringBuffer sb = new StringBuffer();
            MethodUtil.printMethod((String)this.getName(), (IMethodSignature)this.getSignature(), (StringBuffer)sb);
            throw new RuntimeException("Invalid method signature to overload: " + sb.toString());
        }
        this.candidates.add(candidate);
    }

    protected abstract IOpenMethod findMatchingMethod(List<IOpenMethod> var1, IRuntimeContext var2);
}

