/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.types.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.openl.rules.context.IRulesRuntimeContext;
import org.openl.rules.enumeration.CountriesEnum;
import org.openl.rules.enumeration.UsRegionsEnum;
import org.openl.rules.enumeration.UsStatesEnum;
import org.openl.rules.table.properties.ITableProperties;
import org.openl.rules.types.impl.IPropertiesContextMatcher;
import org.openl.rules.types.impl.MatchingConstraint;
import org.openl.rules.types.impl.MatchingResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPropertiesContextMatcher
implements IPropertiesContextMatcher {
    private Map<String, MatchingConstraint<?, ?>> constraints = new HashMap();

    public DefaultPropertiesContextMatcher() {
        this.initilaize();
    }

    @Override
    public MatchingResult match(String propName, ITableProperties props, IRulesRuntimeContext context) {
        MatchingConstraint<?, ?> mc = this.constraints.get(propName);
        if (mc == null) {
            throw new RuntimeException("Unexpectedly could not find a constarint for the property: " + propName);
        }
        return mc.match(props, context);
    }

    @Override
    public void addConstraint(String propertyName, MatchingConstraint<?, ?> ctr) {
        this.constraints.put(propertyName, ctr);
    }

    protected void initilaize() {
        this.constraints.put("effectiveDate", new MatchingConstraint<Date, Date>(){

            @Override
            protected Date getContextValue(IRulesRuntimeContext context) {
                return context.getCurrentDate();
            }

            @Override
            protected Date getPropertyValue(ITableProperties properties) {
                return properties.getEffectiveDate();
            }

            @Override
            protected boolean matchNotNulls(Date propertyValue, Date contextValue) {
                return 1.LE(propertyValue, contextValue);
            }
        });
        this.constraints.put("expirationDate", new MatchingConstraint<Date, Date>(){

            @Override
            protected Date getContextValue(IRulesRuntimeContext context) {
                return context.getCurrentDate();
            }

            @Override
            protected Date getPropertyValue(ITableProperties properties) {
                return properties.getExpirationDate();
            }

            @Override
            protected boolean matchNotNulls(Date propertyValue, Date contextValue) {
                return 2.GE(propertyValue, contextValue);
            }
        });
        this.constraints.put("lob", new MatchingConstraint<String, String>(){

            @Override
            protected String getContextValue(IRulesRuntimeContext context) {
                return context.getLob();
            }

            @Override
            protected String getPropertyValue(ITableProperties properties) {
                return properties.getLob();
            }

            @Override
            protected boolean matchNotNulls(String propertyValue, String contextValue) {
                return 3.EQ(propertyValue, contextValue);
            }
        });
        this.constraints.put("usregion", new MatchingConstraint<UsRegionsEnum, UsRegionsEnum>(){

            @Override
            protected UsRegionsEnum getContextValue(IRulesRuntimeContext context) {
                return context.getUsRegion();
            }

            @Override
            protected UsRegionsEnum getPropertyValue(ITableProperties properties) {
                return properties.getUsregion();
            }

            @Override
            protected boolean matchNotNulls(UsRegionsEnum propertyValue, UsRegionsEnum contextValue) {
                return 4.EQ(propertyValue, contextValue);
            }
        });
        this.constraints.put("country", new MatchingConstraint<CountriesEnum[], CountriesEnum>(){

            @Override
            protected CountriesEnum getContextValue(IRulesRuntimeContext context) {
                return context.getCountry();
            }

            @Override
            protected CountriesEnum[] getPropertyValue(ITableProperties properties) {
                return properties.getCountry();
            }

            @Override
            protected boolean matchNotNulls(CountriesEnum[] propertyValue, CountriesEnum contextValue) {
                return 5.CONTAINS(propertyValue, contextValue);
            }
        });
        this.constraints.put("state", new MatchingConstraint<UsStatesEnum[], UsStatesEnum>(){

            @Override
            protected UsStatesEnum getContextValue(IRulesRuntimeContext context) {
                return context.getUsState();
            }

            @Override
            protected UsStatesEnum[] getPropertyValue(ITableProperties properties) {
                return properties.getState();
            }

            @Override
            protected boolean matchNotNulls(UsStatesEnum[] propertyValue, UsStatesEnum contextValue) {
                return 6.CONTAINS(propertyValue, contextValue);
            }
        });
    }
}

