/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.types.impl;

import org.openl.rules.context.IRulesRuntimeContext;
import org.openl.rules.table.properties.ITableProperties;
import org.openl.rules.types.impl.MatchingResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MatchingConstraint<P, C> {
    public MatchingResult match(ITableProperties properties, IRulesRuntimeContext context) {
        C contextValue = this.getContextValue(context);
        P propertyValue = this.getPropertyValue(properties);
        return this.matchValues(propertyValue, contextValue);
    }

    public MatchingResult matchValues(P propertyValue, C contextValue) {
        if (propertyValue == null || contextValue == null) {
            return MatchingResult.MATCH_BY_DEFAULT;
        }
        if (this.matchNotNulls(propertyValue, contextValue)) {
            return MatchingResult.MATCH;
        }
        return MatchingResult.NO_MATCH;
    }

    protected abstract P getPropertyValue(ITableProperties var1);

    protected abstract C getContextValue(IRulesRuntimeContext var1);

    protected abstract boolean matchNotNulls(P var1, C var2);

    public static <T> boolean LE(Comparable<T> cmp1, Comparable<T> cmp2) {
        return cmp1.compareTo(cmp2) <= 0;
    }

    public static <T> boolean GE(Comparable<T> cmp1, Comparable<T> cmp2) {
        return cmp1.compareTo(cmp2) >= 0;
    }

    public static <T> boolean EQ(Comparable<T> cmp1, Comparable<T> cmp2) {
        return cmp1.compareTo(cmp2) == 0;
    }

    public static <T> boolean CONTAINS(Comparable<T>[] cmp1, Comparable<T> cmp2) {
        for (Comparable<Comparable<Comparable<T>>> comparable : cmp1) {
            if (comparable.compareTo(cmp2) != 0) continue;
            return true;
        }
        return false;
    }
}

