/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.types.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openl.exception.OpenLRuntimeException;
import org.openl.rules.context.IRulesRuntimeContext;
import org.openl.rules.dt.DecisionTable;
import org.openl.rules.lang.xls.binding.XlsMetaInfo;
import org.openl.rules.lang.xls.binding.XlsModuleOpenClass;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.table.properties.ITableProperties;
import org.openl.rules.table.properties.TableProperties;
import org.openl.rules.types.OpenMethodDispatcher;
import org.openl.rules.types.impl.DefaultPropertiesContextMatcher;
import org.openl.rules.types.impl.IPropertiesContextMatcher;
import org.openl.rules.types.impl.MatchingResult;
import org.openl.rules.types.impl.OverloadedMethodChoiceTraceObject;
import org.openl.rules.validation.properties.dimentional.DispatcherTableBuilder;
import org.openl.runtime.IRuntimeContext;
import org.openl.types.IOpenMethod;
import org.openl.vm.IRuntimeEnv;
import org.openl.vm.trace.ITracerObject;
import org.openl.vm.trace.Tracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatchingOpenMethodDispatcher
extends OpenMethodDispatcher {
    private IPropertiesContextMatcher matcher = new DefaultPropertiesContextMatcher();
    private Set<String> propertiesSet;
    private XlsModuleOpenClass moduleOpenClass;
    private OverloadedMethodChoiceTraceObject traceObject;

    public MatchingOpenMethodDispatcher(IOpenMethod method, XlsModuleOpenClass moduleOpenClass) {
        this.decorate(method);
        this.moduleOpenClass = moduleOpenClass;
    }

    @Override
    public Object invoke(Object target, Object[] params, IRuntimeEnv env) {
        if (Tracer.isTracerOn()) {
            return this.invokeTraced(target, params, env);
        }
        return super.invoke(target, params, env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeTraced(Object target, Object[] params, IRuntimeEnv env) {
        Tracer tracer = Tracer.getTracer();
        try {
            this.traceObject = new OverloadedMethodChoiceTraceObject((DecisionTable)this.getDispatcherTable().getMember(), params, this.getCandidates());
            tracer.push((ITracerObject)this.traceObject);
            Object object = super.invoke(target, params, env);
            return object;
        }
        finally {
            tracer.pop();
        }
    }

    @Override
    protected IOpenMethod findMatchingMethod(List<IOpenMethod> candidates, IRuntimeContext context) {
        HashSet<IOpenMethod> selected = new HashSet<IOpenMethod>(candidates);
        this.selectCandidates(selected, (IRulesRuntimeContext)context);
        this.removeInactiveMethods(selected);
        if (Tracer.isTracerOn()) {
            this.traceObject.setResult(selected);
        }
        switch (selected.size()) {
            case 0: {
                throw new RuntimeException(String.format("No matching methods for the context. Details: \n%1$s\nContext: %2$s", this.toString(candidates), context.toString()));
            }
            case 1: {
                return (IOpenMethod)selected.iterator().next();
            }
        }
        throw new RuntimeException(String.format("Ambiguous method dispatch. Details: \n%1$s\nContext: %2$s", this.toString(candidates), context.toString()));
    }

    private TableSyntaxNode[] getTableSyntaxNodes() {
        XlsMetaInfo xlsMetaInfo = this.moduleOpenClass.getXlsMetaInfo();
        return xlsMetaInfo.getXlsModuleNode().getXlsTableSyntaxNodes();
    }

    private TableSyntaxNode getDispatcherTable() {
        TableSyntaxNode[] tables;
        for (TableSyntaxNode tsn : tables = this.getTableSyntaxNodes()) {
            if (!DispatcherTableBuilder.isDispatcherTable(tsn) || !tsn.getMember().getName().endsWith(this.getName())) continue;
            return tsn;
        }
        throw new OpenLRuntimeException(String.format("There is no dispatcher table for [%s] method.", this.getName()));
    }

    private void selectCandidates(Set<IOpenMethod> selected, IRulesRuntimeContext context) {
        this.selectCandidatesByProperty("effectiveDate", selected, context);
        this.selectCandidatesByProperty("expirationDate", selected, context);
        this.selectCandidatesByProperty("lob", selected, context);
        this.selectCandidatesByProperty("usregion", selected, context);
        this.selectCandidatesByProperty("country", selected, context);
        this.selectCandidatesByProperty("state", selected, context);
    }

    private void selectCandidatesByProperty(String propName, Set<IOpenMethod> selected, IRulesRuntimeContext context) {
        if (this.propertiesSet != null && !this.propertiesSet.contains(propName)) {
            return;
        }
        ArrayList<IOpenMethod> nomatched = new ArrayList<IOpenMethod>();
        ArrayList<IOpenMethod> matchedByDefault = new ArrayList<IOpenMethod>();
        boolean matchExists = false;
        for (IOpenMethod method : selected) {
            ITableProperties props = this.getTableProperties(method);
            MatchingResult res = this.matcher.match(propName, props, context);
            switch (res) {
                case NO_MATCH: {
                    nomatched.add(method);
                    break;
                }
                case MATCH_BY_DEFAULT: {
                    matchedByDefault.add(method);
                    break;
                }
                case MATCH: {
                    matchExists = true;
                }
            }
        }
        selected.removeAll(nomatched);
        if (matchExists) {
            selected.removeAll(matchedByDefault);
        }
    }

    private ITableProperties getTableProperties(IOpenMethod method) {
        TableProperties properties = new TableProperties();
        if (method.getInfo().getProperties() != null) {
            for (Map.Entry property : method.getInfo().getProperties().entrySet()) {
                properties.setFieldValue((String)property.getKey(), property.getValue());
            }
        }
        return properties;
    }

    private void removeInactiveMethods(Set<IOpenMethod> candidates) {
        ArrayList<IOpenMethod> inactiveCandidates = new ArrayList<IOpenMethod>();
        for (IOpenMethod candidate : candidates) {
            if (this.isActive(candidate)) continue;
            inactiveCandidates.add(candidate);
        }
        candidates.removeAll(inactiveCandidates);
    }

    private boolean isActive(IOpenMethod method) {
        ITableProperties tableProperties = this.getTableProperties(method);
        return tableProperties.getActive() == null || tableProperties.getActive() != false;
    }

    private String toString(List<IOpenMethod> methods) {
        StringBuilder builder = new StringBuilder();
        builder.append("Candidates: {\n");
        for (IOpenMethod method : methods) {
            ITableProperties tableProperties = this.getTableProperties(method);
            builder.append(tableProperties.toString());
            builder.append("\n");
        }
        builder.append("}\n");
        return builder.toString();
    }
}

