/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.types.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openl.binding.MethodUtil;
import org.openl.rules.dt.DecisionTable;
import org.openl.rules.table.ATableTracerNode;
import org.openl.rules.table.ICell;
import org.openl.rules.table.IGridRegion;
import org.openl.rules.table.ILogicalTable;
import org.openl.types.IOpenMethod;
import org.openl.types.IOpenMethodHeader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OverloadedMethodChoiceTraceObject
extends ATableTracerNode {
    private static final String TYPE = "overloadedMethodChoice";
    private List<IOpenMethod> methodCandidates;

    public OverloadedMethodChoiceTraceObject(DecisionTable dispatcherTable, Object[] params, List<IOpenMethod> methodCandidates) {
        super(dispatcherTable, params);
        this.methodCandidates = methodCandidates;
    }

    public DecisionTable getDispatcherTable() {
        return (DecisionTable)((Object)this.getTraceObject());
    }

    public Collection<IOpenMethod> getSelectedMethods() {
        return (Collection)this.getResult();
    }

    public String getUri() {
        return this.getDispatcherTable().getSourceUrl();
    }

    @Override
    public List<IGridRegion> getGridRegions() {
        ArrayList<IGridRegion> regions = new ArrayList<IGridRegion>();
        for (IOpenMethod method : this.getSelectedMethods()) {
            int methodIndex = this.methodCandidates.indexOf(method);
            ILogicalTable ruleTable = this.getDispatcherTable().getRuleByIndex(methodIndex);
            ICell cell = null;
            for (int row = 0; row < ruleTable.getSource().getHeight(); row += cell.getHeight()) {
                for (int column = 0; column < ruleTable.getSource().getWidth(); column += cell.getWidth()) {
                    cell = ruleTable.getSource().getCell(column, row);
                    regions.add(cell.getAbsoluteRegion());
                }
            }
        }
        return regions;
    }

    public String getType() {
        return TYPE;
    }

    public String getDisplayName(int mode) {
        return "Overloaded method choise for method " + MethodUtil.printMethod((IOpenMethodHeader)((IOpenMethodHeader)this.methodCandidates.get(0)), (int)0, (boolean)false);
    }
}

