/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.validation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openl.OpenL;
import org.openl.exception.OpenLException;
import org.openl.message.OpenLErrorMessage;
import org.openl.message.OpenLMessage;
import org.openl.message.OpenLWarnMessage;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.lang.xls.syntax.TableSyntaxNodeKey;
import org.openl.rules.validation.TablesValidator;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;
import org.openl.validation.ValidationResult;
import org.openl.validation.ValidationStatus;
import org.openl.validation.ValidationUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivePropertyValidator
extends TablesValidator {
    public static final String NO_ACTIVE_TABLE_MESSAGE = "No active table";
    public static final String ODD_ACTIVE_TABLE_MESSAGE = "There can be only one active table";

    @Override
    public ValidationResult validateTables(OpenL openl, TableSyntaxNode[] tableSyntaxNodes, IOpenClass openClass) {
        ValidationResult validationResult = null;
        Map<TableSyntaxNodeKey, List<TableSyntaxNode>> groupedTables = this.groupExecutableTables(tableSyntaxNodes);
        for (TableSyntaxNodeKey key : groupedTables.keySet()) {
            List<TableSyntaxNode> tablesGroup = groupedTables.get(key);
            boolean activeTableWasFound = false;
            for (TableSyntaxNode tsn : tablesGroup) {
                if (!Boolean.TRUE.equals(tsn.getTableProperties().getActive())) continue;
                if (activeTableWasFound) {
                    if (validationResult == null) {
                        validationResult = new ValidationResult(ValidationStatus.FAIL);
                    }
                    SyntaxNodeException exception = new SyntaxNodeException(ODD_ACTIVE_TABLE_MESSAGE, null, (ISyntaxNode)tsn);
                    tsn.addError(exception);
                    ValidationUtils.addValidationMessage((ValidationResult)validationResult, (OpenLMessage)new OpenLErrorMessage((OpenLException)exception));
                    continue;
                }
                activeTableWasFound = true;
            }
            if (activeTableWasFound) continue;
            if (validationResult == null) {
                validationResult = new ValidationResult(ValidationStatus.SUCCESS);
            }
            ValidationUtils.addValidationMessage((ValidationResult)validationResult, (OpenLMessage)new OpenLWarnMessage(NO_ACTIVE_TABLE_MESSAGE, (ISyntaxNode)tablesGroup.get(0)));
        }
        if (validationResult != null) {
            return validationResult;
        }
        return ValidationUtils.validationSuccess();
    }

    private Map<TableSyntaxNodeKey, List<TableSyntaxNode>> groupExecutableTables(TableSyntaxNode[] tableSyntaxNodes) {
        HashMap<TableSyntaxNodeKey, List<TableSyntaxNode>> groupedTables = new HashMap<TableSyntaxNodeKey, List<TableSyntaxNode>>();
        for (TableSyntaxNode tsn : tableSyntaxNodes) {
            if (!(tsn.getMember() instanceof IOpenMethod)) continue;
            TableSyntaxNodeKey key = new TableSyntaxNodeKey(tsn);
            if (!groupedTables.containsKey(key)) {
                groupedTables.put(key, new ArrayList());
            }
            ((List)groupedTables.get(key)).add(tsn);
        }
        return groupedTables;
    }
}

