/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.validation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openl.OpenL;
import org.openl.domain.IDomain;
import org.openl.exception.OpenLException;
import org.openl.message.OpenLErrorMessage;
import org.openl.message.OpenLMessage;
import org.openl.rules.dt.DecisionTable;
import org.openl.rules.dt.element.ICondition;
import org.openl.rules.dt.type.domains.DomainAdaptorFactory;
import org.openl.rules.dt.type.domains.IDomainAdaptor;
import org.openl.rules.dt.validator.DecisionTableAnalyzer;
import org.openl.rules.dt.validator.DecisionTableValidator;
import org.openl.rules.dt.validator.DesionTableValidationResult;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.validation.TablesValidator;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.types.IOpenClass;
import org.openl.types.IParameterDeclaration;
import org.openl.validation.ValidationResult;
import org.openl.validation.ValidationStatus;
import org.openl.validation.ValidationUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GapOverlapValidator
extends TablesValidator {
    private static final String VALIDATION_FAILED = "Validation failed for node : ";
    private ValidationResult validationResult;

    @Override
    public ValidationResult validateTables(OpenL openl, TableSyntaxNode[] tableSyntaxNodes, IOpenClass openClass) {
        this.validationResult = null;
        for (TableSyntaxNode tsn : tableSyntaxNodes) {
            if (!GapOverlapValidator.isValidatableNode(tsn)) continue;
            DesionTableValidationResult dtValidResult = null;
            try {
                Map<String, IDomainAdaptor> domains = this.gatherDomains((DecisionTable)tsn.getMember());
                dtValidResult = DecisionTableValidator.validateTable((DecisionTable)tsn.getMember(), domains, openClass);
            }
            catch (Exception t) {
                this.addError(tsn, VALIDATION_FAILED + tsn.getDisplayName() + ". Reason : " + t.getMessage());
            }
            if (dtValidResult == null || !dtValidResult.hasProblems()) continue;
            tsn.setValidationResult(dtValidResult);
            this.addError(tsn, dtValidResult.toString());
        }
        if (this.validationResult != null) {
            return this.validationResult;
        }
        return ValidationUtils.validationSuccess();
    }

    private Map<String, IDomainAdaptor> gatherDomains(DecisionTable dt) {
        HashMap<String, IDomainAdaptor> domainsMap = new HashMap<String, IDomainAdaptor>();
        DecisionTableAnalyzer analyzer = new DecisionTableAnalyzer(dt);
        for (ICondition condition : dt.getConditionRows()) {
            List<IParameterDeclaration> parameters = this.getAllParameters(condition, analyzer);
            IDomain<?> domain = this.findDomainForConditionVariables(parameters, condition, analyzer);
            if (domain == null) continue;
            IDomainAdaptor adaptor = DomainAdaptorFactory.getAdaptor(domain);
            for (IParameterDeclaration parameter : parameters) {
                domainsMap.put(parameter.getName(), adaptor);
            }
        }
        return domainsMap;
    }

    private List<IParameterDeclaration> getAllParameters(ICondition condition, DecisionTableAnalyzer analyzer) {
        ArrayList<IParameterDeclaration> result = new ArrayList<IParameterDeclaration>();
        IParameterDeclaration[] paramDeclarations = condition.getParams();
        result.addAll(Arrays.asList(paramDeclarations));
        IParameterDeclaration[] referencedSignatureParams = analyzer.referencedSignatureParams(condition);
        result.addAll(Arrays.asList(referencedSignatureParams));
        return result;
    }

    private IDomain<?> findDomainForConditionVariables(List<IParameterDeclaration> parameters, ICondition condition, DecisionTableAnalyzer analyzer) {
        IDomain<?> domain = null;
        for (IParameterDeclaration parameter : parameters) {
            domain = parameter.getType().getDomain();
            if (domain != null) continue;
            domain = analyzer.gatherDomainFromValues(parameter, condition);
        }
        return domain;
    }

    private void addError(TableSyntaxNode sourceNode, String message) {
        if (this.validationResult == null) {
            this.validationResult = new ValidationResult(ValidationStatus.FAIL);
        }
        SyntaxNodeException error = new SyntaxNodeException(message, null, (ISyntaxNode)sourceNode);
        sourceNode.addError(error);
        ValidationUtils.addValidationMessage((ValidationResult)this.validationResult, (OpenLMessage)new OpenLErrorMessage((OpenLException)error));
    }

    private static boolean isValidatableNode(TableSyntaxNode tsn) {
        if (tsn.getMember() instanceof DecisionTable) {
            return !tsn.hasErrors() && "on".equals(tsn.getTableProperties().getPropertyValueAsString("validateDT"));
        }
        return false;
    }
}

