/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.validation;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.openl.OpenL;
import org.openl.message.OpenLMessage;
import org.openl.message.OpenLWarnMessage;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.table.properties.ITableProperties;
import org.openl.rules.validation.TablesValidator;
import org.openl.syntax.ISyntaxNode;
import org.openl.types.IOpenClass;
import org.openl.validation.ValidationResult;
import org.openl.validation.ValidationStatus;
import org.openl.validation.ValidationUtils;

public class UniquePropertyValueValidator
extends TablesValidator {
    private String propertyName;

    public UniquePropertyValueValidator(String propertyName) {
        this.propertyName = propertyName;
    }

    public ValidationResult validateTables(OpenL openl, TableSyntaxNode[] tableSyntaxNodes, IOpenClass openClass) {
        TableSyntaxNode[] activeTables = this.selectActiveTables(tableSyntaxNodes);
        HashMap<Object, TableSyntaxNode> values = new HashMap<Object, TableSyntaxNode>();
        ValidationResult validationResult = null;
        for (TableSyntaxNode tableSyntaxNode : activeTables) {
            Object value;
            ITableProperties tableProperties = tableSyntaxNode.getTableProperties();
            if (tableProperties == null || (value = tableProperties.getPropertyValue(this.propertyName)) == null) continue;
            if (values.containsKey(value)) {
                TableSyntaxNode existsTable = (TableSyntaxNode)values.get(value);
                String message = String.format("Found tables with duplicate property '%s'", this.propertyName);
                if (validationResult == null) {
                    validationResult = new ValidationResult(ValidationStatus.FAIL, null);
                    OpenLWarnMessage warnMessage1 = new OpenLWarnMessage(message, (ISyntaxNode)existsTable);
                    OpenLWarnMessage warnMessage2 = new OpenLWarnMessage(message, (ISyntaxNode)tableSyntaxNode);
                    ValidationUtils.addValidationMessage((ValidationResult)validationResult, (OpenLMessage)warnMessage1);
                    ValidationUtils.addValidationMessage((ValidationResult)validationResult, (OpenLMessage)warnMessage2);
                    continue;
                }
                OpenLWarnMessage warnMessage = new OpenLWarnMessage(message, (ISyntaxNode)tableSyntaxNode);
                ValidationUtils.addValidationMessage((ValidationResult)validationResult, (OpenLMessage)warnMessage);
                continue;
            }
            values.put(value, tableSyntaxNode);
        }
        if (validationResult != null) {
            return validationResult;
        }
        return ValidationUtils.validationSuccess();
    }

    private TableSyntaxNode[] selectActiveTables(TableSyntaxNode[] nodes) {
        List<TableSyntaxNode> collection = Arrays.asList(nodes);
        Collection outputCollection = CollectionUtils.select(collection, (Predicate)new Predicate(){

            public boolean evaluate(Object arg0) {
                TableSyntaxNode tableSyntaxNode = (TableSyntaxNode)arg0;
                if (tableSyntaxNode.getTableProperties() == null || tableSyntaxNode.getTableProperties().getActive() == null) {
                    return true;
                }
                return tableSyntaxNode.getTableProperties().getActive();
            }
        });
        return outputCollection.toArray(new TableSyntaxNode[outputCollection.size()]);
    }
}

