/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.validation.properties.dimentional;

import org.apache.commons.lang.StringUtils;
import org.openl.message.OpenLMessagesUtils;
import org.openl.rules.table.properties.def.TablePropertyDefinition;
import org.openl.rules.table.properties.expressions.match.MatchingExpression;
import org.openl.rules.validation.properties.dimentional.ADimensionPropertyColumn;
import org.openl.rules.validation.properties.dimentional.DimensionPropertiesRules;

public class ArrayDimensionPropertyColumn
extends ADimensionPropertyColumn {
    private TablePropertyDefinition property;
    private DimensionPropertiesRules rules;

    public ArrayDimensionPropertyColumn(TablePropertyDefinition property, DimensionPropertiesRules rules) {
        this.property = property;
        this.rules = rules;
    }

    public String getCodeExpression() {
        String propertyName = this.property.getName();
        MatchingExpression matchExpression = this.property.getExpression();
        StringBuffer codeExpression = new StringBuffer();
        if (matchExpression != null) {
            for (int i = 1; i <= this.getMaxNumberOfValuesForRules(); ++i) {
                if (i > 1) {
                    codeExpression.append(" || ");
                }
                String oneValueName = String.format("%s%s%d", propertyName, "Local", i);
                String expressionForOneValue = matchExpression.getMatchExpression().getCodeExpression(oneValueName);
                codeExpression.append(expressionForOneValue);
            }
        } else {
            String message = String.format("Can`t create expression for \"%s\" property validation.", propertyName);
            OpenLMessagesUtils.addWarn((String)message);
        }
        return codeExpression.toString();
    }

    public String getTitle() {
        return this.property.getDisplayName();
    }

    public String getParameterDeclaration() {
        Class<?> componentType = this.property.getType().getInstanceClass().getComponentType();
        return String.format("%s %s", componentType.getSimpleName(), this.property.getName() + "Local");
    }

    public String getRuleValue(int ruleIndex) {
        return this.getRuleValue(ruleIndex, 0);
    }

    public String getRuleValue(int ruleIndex, int elementNum) {
        String valuesThroughComma = this.rules.getRule(ruleIndex).getPropertyValueAsString(this.property.getName());
        String[] values = StringUtils.split((String)valuesThroughComma, (String)",");
        if (values != null && values.length > elementNum) {
            return values[elementNum];
        }
        return null;
    }

    public boolean isArrayCondition() {
        return true;
    }

    public int getMaxNumberOfValuesForRules() {
        int maxNumberOfArrayValues = 0;
        for (int i = 0; i < this.rules.getRulesNumber(); ++i) {
            int numberOfValues;
            Object[] values = (Object[])this.rules.getRule(i).getPropertyValue(this.property.getName());
            if (values == null || (numberOfValues = values.length) <= maxNumberOfArrayValues) continue;
            maxNumberOfArrayValues = numberOfValues;
        }
        return maxNumberOfArrayValues;
    }
}

