/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.validation.properties.dimentional;

import java.util.Map;
import org.apache.poi.ss.usermodel.Sheet;
import org.openl.rules.dt.DecisionTable;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.xls.XlsSheetGridHelper;
import org.openl.rules.table.xls.XlsSheetGridModel;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethodHeader;
import org.openl.types.impl.MethodSignature;
import org.openl.types.impl.OpenMethodHeader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecisionTableCreator {
    public static final String CURRENT_DATE_PARAM = "currentDate";
    private static String VIRTUAL_EXCEL_FILE = "/FAKE_EXCEL_FILE_FOR_DISPATCHER_TABLES.xls";
    private XlsSheetGridModel sheetGridModel;

    public IGridTable createGridTable(Sheet sheetWithTable) {
        this.createSheetGridModel(sheetWithTable);
        IGridTable[] tables = this.sheetGridModel.getTables();
        return tables[0];
    }

    public XlsSheetGridModel createSheetGridModel(Sheet sheetWithTable) {
        if (this.sheetGridModel == null) {
            this.sheetGridModel = XlsSheetGridHelper.createVirtualGrid(sheetWithTable, VIRTUAL_EXCEL_FILE);
        }
        return this.sheetGridModel;
    }

    public DecisionTable createDecisionTable(String tableName, IOpenClass returnType, IMethodSignature originalSignature, Map<String, IOpenClass> newIncomeParams) {
        int paramsNum = originalSignature.getNumberOfParameters() + newIncomeParams.size();
        IOpenClass[] paramTypes = new IOpenClass[paramsNum];
        String[] paramNames = new String[paramsNum];
        int i = 0;
        for (int j = 0; j < originalSignature.getNumberOfParameters(); ++j) {
            paramTypes[i] = originalSignature.getParameterType(j);
            paramNames[i] = originalSignature.getParameterName(j);
            ++i;
        }
        for (Map.Entry<String, IOpenClass> param : newIncomeParams.entrySet()) {
            paramTypes[i] = param.getValue();
            paramNames[i] = param.getKey();
            ++i;
        }
        MethodSignature signature = new MethodSignature(paramTypes, paramNames);
        IOpenClass declaringClass = null;
        OpenMethodHeader methodHeader = new OpenMethodHeader(tableName, returnType, (IMethodSignature)signature, declaringClass);
        return new DecisionTable((IOpenMethodHeader)methodHeader);
    }
}

