/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.validation.properties.dimentional;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.openl.rules.validation.properties.dimentional.IDecisionTableColumn;
import org.openl.rules.validation.properties.dimentional.IDecisionTableReturnColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecisionTablePOIBuilder {
    public static final String DISPATCHER_TABLES_SHEET = "Dispatcher Tables Sheet";
    private static final int DECISION_TABLE_HEADER_ROWS_NUMBER = 5;
    private static final int CONDITION_TITLE_ROW_INDEX = 4;
    private static final int CONDITION_PARAMETER_ROW_INDEX = 3;
    private static final int CODE_EXPRESSION_ROW_INDEX = 2;
    private static final int CONDITION_NAME_ROW_INDEX = 1;
    private int conditionNumber = 0;
    private int rulesNumber = 0;
    private List<IDecisionTableColumn> simpleConditions;
    private List<IDecisionTableColumn> arrayConditions;
    private IDecisionTableReturnColumn returnColumn;
    private String tableName;
    private Workbook workbook;
    private Sheet sheet;

    public DecisionTablePOIBuilder(String tableName, List<IDecisionTableColumn> conditions, IDecisionTableReturnColumn returnColumn, int rulesNumber) {
        this.tableName = tableName;
        this.initConditions(conditions);
        this.returnColumn = returnColumn;
        this.rulesNumber = rulesNumber;
        this.workbook = new HSSFWorkbook();
        this.sheet = this.workbook.createSheet(DISPATCHER_TABLES_SHEET + tableName);
    }

    private void initConditions(List<IDecisionTableColumn> conditions) {
        this.simpleConditions = new ArrayList<IDecisionTableColumn>();
        this.arrayConditions = new ArrayList<IDecisionTableColumn>();
        for (IDecisionTableColumn condition : conditions) {
            if (condition.isArrayCondition()) {
                this.arrayConditions.add(condition);
                continue;
            }
            this.simpleConditions.add(condition);
        }
    }

    public Sheet buildTable() {
        this.createAllRows();
        int nextColumn = 0;
        for (IDecisionTableColumn condition : this.simpleConditions) {
            this.writeSimpleConditionColumn(nextColumn, condition);
            ++nextColumn;
        }
        for (IDecisionTableColumn condition : this.arrayConditions) {
            int numberOfWrittenColumns = this.writeArrayConditionColumn(nextColumn, condition);
            nextColumn += numberOfWrittenColumns;
        }
        int lastColumnNumber = nextColumn;
        this.writeReturnColumn(lastColumnNumber);
        this.writeHeaderRow(lastColumnNumber);
        return this.sheet;
    }

    private void createAllRows() {
        int tableRowsNumber = this.rulesNumber + 5;
        for (int i = 0; i < tableRowsNumber; ++i) {
            this.sheet.createRow((int)((short)i));
        }
    }

    private void writeSimpleConditionColumn(int columnNumber, IDecisionTableColumn condition) {
        ++this.conditionNumber;
        this.writeSimpleConditionName(columnNumber, condition);
        this.writeSimpleConditionExpression(columnNumber, condition);
        this.writeSimpleConditionInitialization(columnNumber, condition);
        this.writeSimpleConditionDisplayName(columnNumber, condition);
        this.writeSimpleRuleValue(columnNumber, condition);
    }

    private void writeSimpleConditionName(int colNum, IDecisionTableColumn condition) {
        Cell cell = this.sheet.getRow(1).createCell(colNum);
        cell.setCellValue(String.format("%s%s", condition.getColumnType(), this.conditionNumber));
    }

    private void writeSimpleConditionExpression(int columnNumber, IDecisionTableColumn condition) {
        Cell cell = this.sheet.getRow(2).createCell(columnNumber);
        cell.setCellValue(condition.getCodeExpression());
    }

    private void writeSimpleConditionInitialization(int colNum, IDecisionTableColumn condition) {
        Cell cell = this.sheet.getRow(3).createCell(colNum);
        cell.setCellValue(condition.getParameterDeclaration());
    }

    private void writeSimpleConditionDisplayName(int colNum, IDecisionTableColumn condition) {
        Cell cell = this.sheet.getRow(4).createCell(colNum);
        cell.setCellValue(condition.getTitle());
    }

    private void writeSimpleRuleValue(int columnNumber, IDecisionTableColumn condition) {
        for (int i = 0; i < this.rulesNumber; ++i) {
            Cell cell = this.sheet.getRow(5 + i).createCell(columnNumber);
            cell.setCellValue(condition.getRuleValue(i));
        }
    }

    private int writeArrayConditionColumn(int columnNumber, IDecisionTableColumn condition) {
        int numberOfValues = condition.getMaxNumberOfValuesForRules();
        if (numberOfValues > 0) {
            ++this.conditionNumber;
            this.writeArrayConditionName(columnNumber, numberOfValues, condition);
            this.writeArrayConditionExpression(columnNumber, numberOfValues, condition);
            this.writeArrayConditionInitialization(columnNumber, numberOfValues, condition);
            this.writeArrayConditionDisplayName(columnNumber, numberOfValues, condition);
            this.writeArrayRuleValue(columnNumber, numberOfValues, condition);
        }
        return numberOfValues;
    }

    private void writeArrayConditionName(int columnIndex, int numberOfValues, IDecisionTableColumn condition) {
        Cell cell = this.sheet.getRow(1).createCell(columnIndex);
        cell.setCellValue(String.format("%s%s", condition.getColumnType(), this.conditionNumber));
        this.mergeArrayCells(1, columnIndex, numberOfValues);
    }

    private void writeArrayConditionExpression(int columnIndex, int numberOfValues, IDecisionTableColumn condition) {
        Cell cell = this.sheet.getRow(2).createCell(columnIndex);
        cell.setCellValue(condition.getCodeExpression());
        this.mergeArrayCells(2, columnIndex, numberOfValues);
    }

    private void writeArrayConditionInitialization(int columnNumber, int numOfElements, IDecisionTableColumn condition) {
        for (int i = 0; i < numOfElements; ++i) {
            Cell cell = this.sheet.getRow(3).createCell(columnNumber);
            cell.setCellValue(String.format("%s%d", condition.getParameterDeclaration(), i + 1));
            ++columnNumber;
        }
    }

    private void writeArrayConditionDisplayName(int columnIndex, int numberOfValues, IDecisionTableColumn condition) {
        Cell cell = this.sheet.getRow(4).createCell(columnIndex);
        cell.setCellValue(condition.getTitle());
        this.mergeArrayCells(4, columnIndex, numberOfValues);
    }

    private void mergeArrayCells(int rowIndex, int columnIndex, int numberOfValues) {
        int lastMergedColumnIndex = columnIndex + numberOfValues - 1;
        this.sheet.addMergedRegion(new CellRangeAddress(rowIndex, rowIndex, columnIndex, lastMergedColumnIndex));
    }

    private void writeArrayRuleValue(int colNum, int numCountriesColumns, IDecisionTableColumn condition) {
        int startCol = colNum;
        for (int i = 0; i < this.rulesNumber; ++i) {
            for (int j = 0; j < numCountriesColumns; ++j) {
                Cell cell = this.sheet.getRow(i + 5).createCell(colNum);
                cell.setCellValue(condition.getRuleValue(i, colNum - startCol));
                ++colNum;
            }
            colNum = startCol;
        }
    }

    private void writeReturnColumn(int colNum) {
        Cell cell = this.sheet.getRow(1).createCell(colNum);
        cell.setCellValue(this.returnColumn.getColumnType());
        Cell cell1 = this.sheet.getRow(2).createCell(colNum);
        cell1.setCellValue(this.returnColumn.getCodeExpression());
        Cell cell2 = this.sheet.getRow(3).createCell(colNum);
        cell2.setCellValue(this.returnColumn.getParameterDeclaration());
        Cell cell3 = this.sheet.getRow(4).createCell(colNum);
        cell3.setCellValue(this.returnColumn.getTitle());
        for (int i = 0; i < this.rulesNumber; ++i) {
            Cell cellRule = this.sheet.getRow(i + 5).createCell(colNum);
            cellRule.setCellValue(this.returnColumn.getRuleValue(i));
        }
    }

    private String buildMethodHeader() {
        String start = String.format("%s %s %s(", "Rules", this.returnColumn.getReturnType().getDisplayName(0), this.tableName);
        StringBuffer strBuf = new StringBuffer();
        strBuf.append(start);
        strBuf.append(this.returnColumn.paramsThroughComma());
        strBuf.append(")");
        return strBuf.toString();
    }

    private void writeHeaderRow(int lastColNum) {
        int rowNumForHeader = 0;
        String tableName = this.buildMethodHeader();
        Cell cell_0_0 = this.sheet.getRow(rowNumForHeader).createCell(0);
        cell_0_0.setCellValue(tableName);
        this.sheet.addMergedRegion(new CellRangeAddress(rowNumForHeader, rowNumForHeader, cell_0_0.getColumnIndex(), lastColNum));
    }
}

