/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.validation.properties.dimentional;

import java.util.ArrayList;
import java.util.Map;
import org.openl.rules.dt.DecisionTableColumnHeaders;
import org.openl.rules.validation.properties.dimentional.IDecisionTableReturnColumn;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.NullOpenClass;
import org.openl.util.StringTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DimensionPropertiesReturnColumn
implements IDecisionTableReturnColumn {
    private IOpenClass originalReturnType;
    private String originalTableName;
    private IMethodSignature originalSignature;
    private Map<String, IOpenClass> newIncomeParams;
    private static final String RESULT_VAR = "result";

    public DimensionPropertiesReturnColumn(IOpenClass originalReturnType, String originalTableName, IMethodSignature originalSignature, Map<String, IOpenClass> newIncomeParams) {
        this.originalReturnType = originalReturnType;
        this.originalTableName = originalTableName;
        this.originalSignature = originalSignature;
        this.newIncomeParams = newIncomeParams;
    }

    @Override
    public String getParameterDeclaration() {
        return String.format("%s %s", this.originalReturnType.getDisplayName(0), RESULT_VAR);
    }

    @Override
    public String getCodeExpression() {
        return RESULT_VAR;
    }

    @Override
    public String getTitle() {
        return RESULT_VAR.toUpperCase();
    }

    @Override
    public String getRuleValue(int ruleIndex, int elementNum) {
        return String.format("=%s(%s)", this.originalTableName, this.originalParamsThroughComma());
    }

    @Override
    public IOpenClass getReturnType() {
        return this.originalReturnType;
    }

    private String originalParamsThroughComma() {
        ArrayList<String> values = new ArrayList<String>();
        for (int i = 0; i < this.originalSignature.getNumberOfParameters(); ++i) {
            values.add(this.originalSignature.getParameterName(i));
        }
        return StringTool.listToStringThroughCommas(values);
    }

    @Override
    public String paramsThroughComma() {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append(this.originalParamsWithTypesThroughComma());
        strBuf.append(", ");
        strBuf.append(this.paramsWithTypesThroughComma(this.newIncomeParams));
        return strBuf.toString();
    }

    private String originalParamsWithTypesThroughComma() {
        ArrayList<String> values = new ArrayList<String>();
        for (int j = 0; j < this.originalSignature.getNumberOfParameters(); ++j) {
            if (this.originalSignature.getParameterType(j) instanceof NullOpenClass) continue;
            values.add(String.format("%s %s", this.originalSignature.getParameterType(j).getInstanceClass().getSimpleName(), this.originalSignature.getParameterName(j)));
        }
        return StringTool.listToStringThroughCommas(values);
    }

    private String paramsWithTypesThroughComma(Map<String, IOpenClass> params) {
        ArrayList<String> values = new ArrayList<String>();
        for (Map.Entry<String, IOpenClass> param : params.entrySet()) {
            values.add(String.format("%s %s", param.getValue().getInstanceClass().getSimpleName(), param.getKey()));
        }
        return StringTool.listToStringThroughCommas(values);
    }

    @Override
    public int getMaxNumberOfValuesForRules() {
        return 1;
    }

    @Override
    public String getRuleValue(int ruleIndex) {
        return this.getRuleValue(ruleIndex, 0);
    }

    @Override
    public boolean isArrayCondition() {
        return false;
    }

    @Override
    public String getColumnType() {
        return DecisionTableColumnHeaders.RETURN.getHeaderKey();
    }
}

