/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.validation.properties.dimentional;

import java.util.Map;
import org.openl.OpenL;
import org.openl.exception.OpenLException;
import org.openl.exception.OpenLRuntimeException;
import org.openl.message.OpenLErrorMessage;
import org.openl.message.OpenLMessage;
import org.openl.rules.dt.DecisionTable;
import org.openl.rules.dt.type.domains.DimensionPropertiesDomainsCollector;
import org.openl.rules.dt.type.domains.IDomainAdaptor;
import org.openl.rules.dt.validator.DecisionTableValidator;
import org.openl.rules.dt.validator.DesionTableValidationResult;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.validation.TablesValidator;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.types.IOpenClass;
import org.openl.validation.ValidationResult;
import org.openl.validation.ValidationStatus;
import org.openl.validation.ValidationUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DimensionPropertiesValidator
extends TablesValidator {
    private static final String VALIDATION_FAILED = "Validation failed for dispatcher table";

    @Override
    public ValidationResult validateTables(OpenL openl, TableSyntaxNode[] tableSyntaxNodes, IOpenClass openClass) {
        ValidationResult validationResult = null;
        Map<String, IDomainAdaptor> propertiesDomains = this.getDomainsForDimensionalProperties(tableSyntaxNodes);
        for (TableSyntaxNode tsn : tableSyntaxNodes) {
            OpenLMessage tableValidationMessage;
            if (!this.isDimensionPropertiesDispatcherTable(tsn) || (tableValidationMessage = this.validateDecisionTable(tsn, propertiesDomains, openClass)) == null) continue;
            if (validationResult == null) {
                validationResult = new ValidationResult(ValidationStatus.FAIL);
            }
            ValidationUtils.addValidationMessage(validationResult, (OpenLMessage)tableValidationMessage);
        }
        if (validationResult != null) {
            return validationResult;
        }
        return ValidationUtils.validationSuccess();
    }

    private OpenLMessage validateDecisionTable(TableSyntaxNode tsn, Map<String, IDomainAdaptor> propertiesDomains, IOpenClass openClass) {
        OpenLErrorMessage validationMessage = null;
        DesionTableValidationResult tableValidationResult = null;
        try {
            tableValidationResult = DecisionTableValidator.validateTable((DecisionTable)tsn.getMember(), propertiesDomains, openClass);
        }
        catch (Exception t) {
            throw new OpenLRuntimeException(VALIDATION_FAILED, (Throwable)t);
        }
        if (tableValidationResult != null && tableValidationResult.hasProblems()) {
            tsn.setValidationResult(tableValidationResult);
            SyntaxNodeException error = new SyntaxNodeException(tableValidationResult.toString(), null, (ISyntaxNode)tsn);
            tsn.addError(error);
            validationMessage = new OpenLErrorMessage((OpenLException)error);
        }
        return validationMessage;
    }

    private boolean isDimensionPropertiesDispatcherTable(TableSyntaxNode tsn) {
        return tsn.getDisplayName() != null && tsn.getDisplayName().contains("validateGapOverlap") && tsn.getMember() instanceof DecisionTable;
    }

    private Map<String, IDomainAdaptor> getDomainsForDimensionalProperties(TableSyntaxNode[] tableSyntaxNodes) {
        DimensionPropertiesDomainsCollector domainCollector = new DimensionPropertiesDomainsCollector();
        domainCollector.gatherPropertiesDomains(tableSyntaxNodes);
        Map<String, IDomainAdaptor> gatheredPropertiesDomains = domainCollector.getGatheredPropertiesDomains();
        return gatheredPropertiesDomains;
    }
}

