/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.validation.properties.dimentional;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.Sheet;
import org.openl.OpenL;
import org.openl.binding.IBindingContextDelegator;
import org.openl.binding.MethodUtil;
import org.openl.rules.binding.RulesModuleBindingContext;
import org.openl.rules.context.IRulesRuntimeContext;
import org.openl.rules.dt.DecisionTable;
import org.openl.rules.dt.DecisionTableLoader;
import org.openl.rules.lang.xls.XlsNodeTypes;
import org.openl.rules.lang.xls.binding.XlsMetaInfo;
import org.openl.rules.lang.xls.binding.XlsModuleOpenClass;
import org.openl.rules.lang.xls.syntax.HeaderSyntaxNode;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.lang.xls.syntax.TableSyntaxNodeKey;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.properties.ITableProperties;
import org.openl.rules.table.properties.PropertiesLoader;
import org.openl.rules.table.properties.TableProperties;
import org.openl.rules.table.properties.def.TablePropertyDefinition;
import org.openl.rules.table.properties.def.TablePropertyDefinitionUtils;
import org.openl.rules.table.syntax.GridLocation;
import org.openl.rules.table.xls.XlsSheetGridModel;
import org.openl.rules.validation.properties.dimentional.DecisionTableCreator;
import org.openl.rules.validation.properties.dimentional.DecisionTablePOIBuilder;
import org.openl.rules.validation.properties.dimentional.DimensionProperiesColumnMaker;
import org.openl.rules.validation.properties.dimentional.DimensionPropertiesReturnColumn;
import org.openl.rules.validation.properties.dimentional.DimensionPropertiesRules;
import org.openl.rules.validation.properties.dimentional.IDecisionTableColumn;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMember;
import org.openl.types.IOpenMethod;
import org.openl.types.IOpenMethodHeader;
import org.openl.types.impl.AMethod;
import org.openl.types.impl.MethodKey;
import org.openl.types.java.JavaOpenClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DispatcherTableBuilder {
    private static final Map<String, IOpenClass> incomeParams;
    public static final String DEFAULT_DISPATCHER_TABLE_NAME = "validateGapOverlap";
    private OpenL openl;
    private XlsModuleOpenClass moduleOpenClass;
    private RulesModuleBindingContext moduleContext;

    private static boolean belongsToExcluded(String methodName) {
        boolean result = false;
        if ("getValue".equals(methodName)) {
            result = true;
        }
        return result;
    }

    public static boolean isDispatcherTable(TableSyntaxNode tsn) {
        IOpenMember member = tsn.getMember();
        if (member instanceof IOpenMethod) {
            return member.getName().startsWith(DEFAULT_DISPATCHER_TABLE_NAME);
        }
        return false;
    }

    public DispatcherTableBuilder(OpenL openl, XlsModuleOpenClass moduleOpenClass, RulesModuleBindingContext moduleContext) {
        this.openl = openl;
        this.moduleContext = moduleContext;
        this.moduleOpenClass = moduleOpenClass;
    }

    public void buildDispatcherTables() {
        Map<MethodKey, List<TableSyntaxNode>> groupedTables = this.groupExecutableTables();
        for (List<TableSyntaxNode> tablesGroup : groupedTables.values()) {
            List<TableSyntaxNode> overloadedTablesGroup = this.excludeOveloadedByVersion(tablesGroup);
            if (overloadedTablesGroup.size() <= 1) continue;
            this.buildTableForGroup(overloadedTablesGroup);
        }
    }

    private List<TableSyntaxNode> excludeOveloadedByVersion(List<TableSyntaxNode> tablesGroup) {
        HashSet<TableSyntaxNodeKey> differentTables = new HashSet<TableSyntaxNodeKey>();
        ArrayList<TableSyntaxNode> result = new ArrayList<TableSyntaxNode>();
        for (TableSyntaxNode tsn : tablesGroup) {
            TableSyntaxNodeKey key = new TableSyntaxNodeKey(tsn);
            if (differentTables.contains(key)) continue;
            differentTables.add(key);
            result.add(tsn);
        }
        return result;
    }

    private void addNewTsnToTopNode(TableSyntaxNode tsn) {
        XlsMetaInfo xlsMetaInfo = this.moduleOpenClass.getXlsMetaInfo();
        xlsMetaInfo.getXlsModuleNode().getWorkbookSyntaxNodes()[0].getWorksheetSyntaxNodes()[0].addNode((ISyntaxNode)tsn);
    }

    private void buildTableForGroup(List<TableSyntaxNode> tablesGroup) {
        TableSyntaxNode groupMember = tablesGroup.get(0);
        String originalTableName = this.getOriginalTableName(groupMember);
        String newTableName = "validateGapOverlap_" + originalTableName;
        List<ITableProperties> propertiesValues = this.getPropertiesValues(tablesGroup);
        Sheet sheetWithTable = this.createTable(groupMember, newTableName, propertiesValues);
        DecisionTableCreator decisionTableCreator = new DecisionTableCreator();
        IGridTable gridTable = decisionTableCreator.createGridTable(sheetWithTable);
        XlsSheetGridModel sheetGridModel = decisionTableCreator.createSheetGridModel(sheetWithTable);
        TableSyntaxNode tsn = this.createTableSyntaxNode(sheetGridModel, gridTable);
        IMethodSignature originalSignature = this.getOriginalTableSignature(groupMember);
        IOpenClass originalReturnType = this.getOriginalTableReturnType(groupMember);
        DecisionTable decisionTable = decisionTableCreator.createDecisionTable(newTableName, originalReturnType, originalSignature, incomeParams);
        tsn.setMember((IOpenMember)decisionTable);
        this.loadCreatedTable(decisionTable, tsn);
        IOpenMethod groupMemberMethod = (IOpenMethod)groupMember.getMember();
        this.setPropertiesForDispatcherTable(groupMemberMethod, tsn);
    }

    private Sheet createTable(TableSyntaxNode groupMember, String newTableName, List<ITableProperties> propertiesValues) {
        DecisionTablePOIBuilder tableBulder = this.initTableBuilder(groupMember, newTableName, propertiesValues);
        return tableBulder.buildTable();
    }

    private List<ITableProperties> getPropertiesValues(List<TableSyntaxNode> tablesGroup) {
        ArrayList<ITableProperties> propertiesValues = new ArrayList<ITableProperties>();
        for (TableSyntaxNode tsn : tablesGroup) {
            propertiesValues.add(tsn.getTableProperties());
        }
        return propertiesValues;
    }

    private String getOriginalTableName(TableSyntaxNode groupMember) {
        return ((AMethod)groupMember.getMember()).getHeader().getName();
    }

    private IOpenClass getOriginalTableReturnType(TableSyntaxNode groupMember) {
        return ((AMethod)groupMember.getMember()).getHeader().getType();
    }

    private IMethodSignature getOriginalTableSignature(TableSyntaxNode tsn) {
        return ((AMethod)tsn.getMember()).getHeader().getSignature();
    }

    private DecisionTablePOIBuilder initTableBuilder(TableSyntaxNode groupMember, String newTableName, List<ITableProperties> propertiesValues) {
        List<TablePropertyDefinition> dimensionalPropertiesDef = TablePropertyDefinitionUtils.getDimensionalTableProperties();
        String originalTableName = this.getOriginalTableName(groupMember);
        IMethodSignature originalSignature = this.getOriginalTableSignature(groupMember);
        IOpenClass originalReturnType = this.getOriginalTableReturnType(groupMember);
        DimensionPropertiesReturnColumn returnColumn = new DimensionPropertiesReturnColumn(originalReturnType, originalTableName, originalSignature, incomeParams);
        ArrayList<IDecisionTableColumn> conditions = new ArrayList<IDecisionTableColumn>();
        DimensionPropertiesRules rules = new DimensionPropertiesRules(propertiesValues);
        for (TablePropertyDefinition dimensionProperty : dimensionalPropertiesDef) {
            if (!this.isPropertyValueSetInTables(dimensionProperty.getName(), propertiesValues)) continue;
            conditions.add(DimensionProperiesColumnMaker.makeColumn(dimensionProperty, rules));
        }
        return new DecisionTablePOIBuilder(newTableName, conditions, returnColumn, rules.getRulesNumber());
    }

    private boolean isPropertyValueSetInTables(String propertyName, List<ITableProperties> tableProperties) {
        boolean isPropertyValueSet = false;
        for (ITableProperties properties : tableProperties) {
            String propertyValue = properties.getPropertyValueAsString(propertyName);
            if (!StringUtils.isNotEmpty((String)propertyValue)) continue;
            isPropertyValueSet = true;
            break;
        }
        return isPropertyValueSet;
    }

    private void loadCreatedTable(DecisionTable decisionTable, TableSyntaxNode tsn) {
        PropertiesLoader propLoader = new PropertiesLoader(this.openl, this.moduleContext, this.moduleOpenClass);
        propLoader.loadDefaultProperties(tsn);
        DecisionTableLoader dtLoader = new DecisionTableLoader();
        try {
            dtLoader.loadAndBind(tsn, decisionTable, this.openl, null, (IBindingContextDelegator)this.moduleContext);
            this.addNewTsnToTopNode(tsn);
        }
        catch (SyntaxNodeException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setPropertiesForDispatcherTable(IOpenMethod groupMemberMethod, TableSyntaxNode tsn) {
        TableProperties properties = (TableProperties)tsn.getTableProperties();
        properties.setFieldValue("category", "Autogenerated - Dispatch by Properties");
        properties.setFieldValue("description", " Automatically created table to dispatch by dimensional properties values for method: " + MethodUtil.printMethod((IOpenMethodHeader)groupMemberMethod, (int)0, (boolean)true) + ". Please, edit original tables to make any change to the overloading logic.");
    }

    private TableSyntaxNode createTableSyntaxNode(XlsSheetGridModel sheetGridModel, IGridTable gridTable) {
        String type = XlsNodeTypes.XLS_DT.toString();
        GridLocation pos = new GridLocation(gridTable);
        HeaderSyntaxNode headerSyntaxNode = new HeaderSyntaxNode(null, new IdentifierNode(null, null, "Rules", null));
        return new TableSyntaxNode(type, pos, sheetGridModel.getSheetSource(), gridTable, headerSyntaxNode);
    }

    private Map<MethodKey, List<TableSyntaxNode>> groupExecutableTables() {
        TableSyntaxNode[] tableSyntaxNodes = this.getTableSyntaxNodes();
        HashMap<MethodKey, List<TableSyntaxNode>> groupedTables = new HashMap<MethodKey, List<TableSyntaxNode>>();
        for (TableSyntaxNode tsn : tableSyntaxNodes) {
            if (!(tsn.getMember() instanceof IOpenMethod)) continue;
            MethodKey key = new MethodKey((IOpenMethod)tsn.getMember());
            if (!groupedTables.containsKey(key)) {
                groupedTables.put(key, new ArrayList());
            }
            ((List)groupedTables.get(key)).add(tsn);
        }
        return groupedTables;
    }

    private TableSyntaxNode[] getTableSyntaxNodes() {
        XlsMetaInfo xlsMetaInfo = this.moduleOpenClass.getXlsMetaInfo();
        return xlsMetaInfo.getXlsModuleNode().getXlsTableSyntaxNodes();
    }

    static {
        Method[] methods;
        incomeParams = new HashMap<String, IOpenClass>();
        for (Method method : methods = IRulesRuntimeContext.class.getDeclaredMethods()) {
            String methodName = method.getName();
            if (!methodName.startsWith("get") || DispatcherTableBuilder.belongsToExcluded(methodName)) continue;
            String fieldName = methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
            incomeParams.put(fieldName, (IOpenClass)JavaOpenClass.getOpenClass(method.getReturnType()));
        }
    }
}

