/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.validation.properties.dimentional;

import org.openl.message.OpenLMessagesUtils;
import org.openl.rules.table.properties.def.TablePropertyDefinition;
import org.openl.rules.table.properties.expressions.match.MatchingExpression;
import org.openl.rules.validation.properties.dimentional.ADimensionPropertyColumn;
import org.openl.rules.validation.properties.dimentional.DimensionPropertiesRules;

public class SimpleDimensionPropertyColumn
extends ADimensionPropertyColumn {
    private DimensionPropertiesRules rules;
    private TablePropertyDefinition property;

    public SimpleDimensionPropertyColumn(TablePropertyDefinition property, DimensionPropertiesRules rules) {
        this.property = property;
        this.rules = rules;
    }

    public String getCodeExpression() {
        return this.getCodeExpression(0);
    }

    public String getCodeExpression(int numberOfValues) {
        String result = "";
        String propertyName = this.property.getName();
        MatchingExpression matchExpression = this.property.getExpression();
        if (matchExpression != null) {
            result = matchExpression.getMatchExpression().getCodeExpression(propertyName + "Local");
        } else {
            String message = String.format("Can`t create expression for \"%s\" property validation.", propertyName);
            OpenLMessagesUtils.addWarn((String)message);
        }
        return result;
    }

    public String getTitle() {
        return this.property.getDisplayName();
    }

    public String getParameterDeclaration() {
        String propertyTypeName = this.property.getType().getInstanceClass().getSimpleName();
        return String.format("%s %s", propertyTypeName, this.property.getName() + "Local");
    }

    public String getRuleValue(int ruleIndex, int elementNum) {
        return this.rules.getRule(ruleIndex).getPropertyValueAsString(this.property.getName());
    }
}

