/*
 * Decompiled with CFR 0.152.
 */
package org.openl.commons.web.jsf;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import javax.el.ELContext;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FacesUtils {
    public static SelectItem[] createSelectItems(Collection<String> values) {
        SelectItem[] items = new SelectItem[values.size()];
        int index = 0;
        for (String value : values) {
            items[index++] = new SelectItem((Object)value);
        }
        return items;
    }

    public static SelectItem[] createSelectItems(String[] values) {
        SelectItem[] items = new SelectItem[values.length];
        for (int i = 0; i < items.length; ++i) {
            items[i] = new SelectItem((Object)values[i]);
        }
        return items;
    }

    public static FacesContext getFacesContext() {
        return FacesContext.getCurrentInstance();
    }

    public static ValueExpression createValueExpression(String expressionString) {
        FacesContext context = FacesContext.getCurrentInstance();
        ELContext elContext = context.getELContext();
        ValueExpression valueExpression = context.getApplication().getExpressionFactory().createValueExpression(elContext, expressionString, Object.class);
        return valueExpression;
    }

    public static MethodExpression createMethodExpression(String expressionString) {
        return FacesUtils.createMethodExpression(expressionString, null);
    }

    public static MethodExpression createMethodExpression(String expressionString, Class<?>[] paramTypes) {
        FacesContext context = FacesContext.getCurrentInstance();
        ELContext elContext = context.getELContext();
        MethodExpression methodExpression = context.getApplication().getExpressionFactory().createMethodExpression(elContext, expressionString, null, (Class[])(paramTypes == null ? new Class[]{} : paramTypes));
        return methodExpression;
    }

    public static Object getValueExpressionValue(String expressionString) {
        ValueExpression valueExpression = FacesUtils.createValueExpression(expressionString);
        return valueExpression.getValue(FacesUtils.getELContext());
    }

    public static Object getValueExpressionValue(UIComponent component, String componentParam) {
        ValueExpression valueExpression = component.getValueExpression(componentParam);
        if (valueExpression != null) {
            return valueExpression.getValue(FacesUtils.getELContext());
        }
        return null;
    }

    public static String getValueExpressionString(UIComponent component, String componentParam) {
        ValueExpression valueExpression = component.getValueExpression(componentParam);
        if (valueExpression != null) {
            return valueExpression.getExpressionString();
        }
        return null;
    }

    public static Object invokeMethodExpression(String expressionString) {
        return FacesUtils.invokeMethodExpression(expressionString, null, null);
    }

    public static Object invokeMethodExpression(String expressionString, Object[] params, Class<?>[] paramTypes) {
        MethodExpression methodExpression = FacesUtils.createMethodExpression(expressionString, paramTypes);
        return methodExpression.invoke(FacesUtils.getELContext(), params == null ? new Object[]{} : params);
    }

    public static ELContext getELContext() {
        ELContext elContext = FacesUtils.getFacesContext().getELContext();
        return elContext;
    }

    public static Map<String, Object> getRequestMap() {
        return FacesUtils.getExternalContext().getRequestMap();
    }

    public static String getRequestParameter(String parameterName) {
        return FacesUtils.getRequestParameterMap().get(parameterName);
    }

    public static Map<String, String> getRequestParameterMap() {
        return FacesUtils.getExternalContext().getRequestParameterMap();
    }

    public static Map<String, Object> getSessionMap() {
        return FacesUtils.getExternalContext().getSessionMap();
    }

    public static Object getSessionParam(String name) {
        return FacesUtils.getSessionMap().get(name);
    }

    public static ExternalContext getExternalContext() {
        return FacesUtils.getFacesContext().getExternalContext();
    }

    public static ServletRequest getRequest() {
        return (ServletRequest)FacesUtils.getExternalContext().getRequest();
    }

    public static ServletResponse getResponse() {
        return (ServletResponse)FacesUtils.getExternalContext().getResponse();
    }

    public static HttpSession getSession() {
        return (HttpSession)FacesUtils.getExternalContext().getSession(false);
    }

    public static String getContextPath() {
        return FacesUtils.getExternalContext().getRequestContextPath();
    }

    public static void redirect(String page) throws IOException {
        HttpServletResponse response = (HttpServletResponse)FacesUtils.getResponse();
        response.sendRedirect(page);
    }
}

