/*
 * Decompiled with CFR 0.152.
 */
package org.openl.commons.web.jsf.facelets.acegi;

import java.lang.reflect.InvocationTargetException;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.userdetails.UserDetails;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AcegiFunctions {
    private static final Log log = LogFactory.getLog(AcegiFunctions.class);

    public static String authentication(String operation) {
        if (operation == null) {
            log.debug((Object)"Operation is not provided. Empty result string will be returned");
            return "";
        }
        SecurityContext ctx = SecurityContextHolder.getContext();
        if (ctx == null || ctx.getAuthentication() == null) {
            log.debug((Object)"Can't find security context or context has no authentication");
            return "";
        }
        Authentication auth = ctx.getAuthentication();
        Object principal = null;
        if (auth.getPrincipal() != null && auth.getPrincipal() instanceof UserDetails) {
            try {
                String property;
                principal = auth.getPrincipal();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Principal is " + principal));
                }
                if ((property = BeanUtils.getProperty((Object)principal, (String)operation)) == null) {
                    log.debug((Object)(principal + " property  " + operation + " is null"));
                    return "";
                }
                return property;
            }
            catch (IllegalAccessException e) {
                log.warn((Object)("Error when trying to get property " + operation + " of " + principal + ". Empty string will be returned"));
                return "";
            }
            catch (InvocationTargetException e) {
                log.warn((Object)("Error when trying to get property " + operation + " of " + principal + ". Empty string will be returned"));
                return "";
            }
            catch (NoSuchMethodException e) {
                log.warn((Object)("Error when trying to get property " + operation + " of " + principal + ". Empty string will be returned"));
                return "";
            }
        }
        if (auth.getPrincipal() != null) {
            return auth.getPrincipal().toString();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Authentication has no principal. Or its principal is not an instanceof acegi UserDetails");
        }
        return "";
    }
}

