/*
 * Decompiled with CFR 0.152.
 */
package org.openl.commons.web.jsf.facelets.acegi;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.FaceletException;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.TagConfig;
import com.sun.facelets.tag.TagHandler;
import java.io.IOException;
import java.util.HashSet;
import java.util.StringTokenizer;
import javax.el.ELException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.acegisecurity.Authentication;
import org.acegisecurity.acl.AclEntry;
import org.acegisecurity.acl.AclManager;
import org.acegisecurity.acl.basic.BasicAclEntry;
import org.acegisecurity.context.SecurityContextHolder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class AclHandler
extends TagHandler {
    private static final Log log = LogFactory.getLog(AclHandler.class);
    private TagAttribute domainObject = this.getAttribute("domainObject");
    private TagAttribute hasPermission = this.getAttribute("hasPermission");

    public AclHandler(TagConfig tagConfig) {
        super(tagConfig);
    }

    public void apply(FaceletContext faceletContext, UIComponent parent) throws IOException, FacesException, FaceletException, ELException {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        ApplicationContext context = this.getAppCtx(faceletContext);
        String[] beans = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)context, AclManager.class, (boolean)false, (boolean)false);
        if (beans.length == 0) {
            log.warn((Object)("No AclManager would found the application context: " + context.toString()));
            log.warn((Object)"All secured resources will be allowed by default");
            this.nextHandler.apply(faceletContext, parent);
            return;
        }
        AclManager aclManager = (AclManager)context.getBean(beans[0]);
        Object resolvedDomainObject = this.domainObject.getObject(faceletContext);
        AclEntry[] acls = aclManager.getAcls(resolvedDomainObject, auth);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Authentication: '" + auth + "' has: " + (acls == null ? 0 : acls.length) + " AclEntrys for domain object: '" + resolvedDomainObject + "' from AclManager: '" + aclManager.toString() + "'"));
        }
        if (acls == null || acls.length == 0) {
            log.debug((Object)"No alcs provided. Skip evaluation");
            return;
        }
        Integer[] requiredIntegers = this.parseIntegersString(this.hasPermission.getValue());
        for (int i = 0; i < acls.length; ++i) {
            if (!(acls[i] instanceof BasicAclEntry)) continue;
            BasicAclEntry processableAcl = (BasicAclEntry)acls[i];
            for (int j = 0; j < requiredIntegers.length; ++j) {
                if (!processableAcl.isPermitted(requiredIntegers[j].intValue())) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Including tag body as found permission: " + requiredIntegers[j] + " due to AclEntry: '" + processableAcl + "'"));
                }
                this.nextHandler.apply(faceletContext, parent);
                return;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"No permission, so skipping tag body");
        }
    }

    private ApplicationContext getAppCtx(FaceletContext ctx) {
        HttpServletRequest request = (HttpServletRequest)ctx.getFacesContext().getExternalContext().getRequest();
        return WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)request.getSession().getServletContext());
    }

    private Integer[] parseIntegersString(String integersString) throws NumberFormatException {
        HashSet<Integer> integers = new HashSet<Integer>();
        StringTokenizer tokenizer = new StringTokenizer(integersString, ",", false);
        while (tokenizer.hasMoreTokens()) {
            String integer = tokenizer.nextToken();
            integers.add(new Integer(integer));
        }
        return integers.toArray(new Integer[0]);
    }
}

