/*
 * Decompiled with CFR 0.152.
 */
package org.openl.commons.web.jsf.facelets.acegi;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.FaceletException;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.TagConfig;
import com.sun.facelets.tag.TagHandler;
import java.io.IOException;
import javax.el.ELException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.acegisecurity.taglibs.velocity.AuthzImpl;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class AuthorizeHandler
extends TagHandler {
    private TagAttribute ifAllGranted;
    private TagAttribute ifAnyGranted = this.getAttribute("ifAnyGranted");
    private TagAttribute ifNotGranted;

    public AuthorizeHandler(TagConfig config) {
        super(config);
        this.ifAllGranted = this.getAttribute("ifAllGranted");
        this.ifNotGranted = this.getAttribute("ifNotGranted");
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, FaceletException, ELException {
        AuthzImpl authz = new AuthzImpl();
        authz.setAppCtx(this.getAppCtx(ctx));
        String roles = null;
        boolean apply = false;
        if (this.ifNotGranted != null && StringUtils.isNotEmpty((String)(roles = this.ifNotGranted.getValue(ctx)))) {
            apply = authz.noneGranted(roles);
        }
        if (this.ifAllGranted != null && StringUtils.isNotEmpty((String)(roles = this.ifAllGranted.getValue(ctx)))) {
            apply = authz.allGranted(roles);
        }
        if (this.ifAnyGranted != null && StringUtils.isNotEmpty((String)(roles = this.ifAnyGranted.getValue(ctx)))) {
            apply = authz.anyGranted(roles);
        }
        if (apply) {
            this.nextHandler.apply(ctx, parent);
        }
    }

    private ApplicationContext getAppCtx(FaceletContext ctx) {
        HttpServletRequest request = (HttpServletRequest)ctx.getFacesContext().getExternalContext().getRequest();
        return WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)request.getSession().getServletContext());
    }
}

