/*
 * Decompiled with CFR 0.152.
 */
package org.openl.commons.web.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import javax.servlet.ServletRequest;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openl.util.StringTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebTool {
    private static final Log LOG = LogFactory.getLog(WebTool.class);

    public static String listRequestParams(ServletRequest request) {
        return WebTool.listRequestParams(request.getParameterMap(), null);
    }

    public static String listRequestParams(ServletRequest request, String[] exceptParams) {
        return WebTool.listRequestParams(request.getParameterMap(), exceptParams);
    }

    public static String listRequestParams(Map<String, String[]> paramsMap, String[] exceptParams) {
        StringBuilder buf = new StringBuilder();
        for (String paramName : paramsMap.keySet()) {
            if (ArrayUtils.contains((Object[])exceptParams, (Object)paramName)) continue;
            if (buf.length() != 0) {
                buf.append('&');
            }
            String[] paramValues = paramsMap.get(paramName);
            buf.append(paramName).append('=').append(StringTool.encodeURL((String)paramValues[0]));
        }
        return buf.toString();
    }

    public static boolean isLocalRequest(ServletRequest request) {
        String remote = request.getRemoteAddr();
        boolean b = WebTool.isLoopbackAddress(remote);
        return b;
    }

    public static boolean isLoopbackAddress(String ip) {
        if (StringUtils.isEmpty((String)ip)) {
            return false;
        }
        try {
            InetAddress addr = InetAddress.getByName(ip);
            return addr != null && addr.isLoopbackAddress();
        }
        catch (UnknownHostException e) {
            LOG.info((Object)("Cannot check '" + ip + "'."), (Throwable)e);
            return false;
        }
    }
}

