/*
 * Decompiled with CFR 0.152.
 */
package org.openl.eclipse.base;

import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;

public class OpenlNature
implements IProjectNature {
    IProject openLProject = null;

    private void addToBuildSpec(String builderID) throws CoreException {
        IProjectDescription description = this.openLProject.getDescription();
        for (ICommand c : description.getBuildSpec()) {
            if (!c.getBuilderName().equals(builderID)) continue;
            return;
        }
        ICommand command = description.newCommand();
        command.setBuilderName(builderID);
        this.setJavaCommand(description, command);
    }

    public void configure() throws CoreException {
        this.addToBuildSpec("org.openl.eclipse.ui.openlbuilder");
    }

    public void deconfigure() throws CoreException {
        this.removeFromBuildSpec("org.openl.eclipse.ui.openlbuilder");
    }

    public IProject getProject() {
        return this.openLProject;
    }

    protected void removeFromBuildSpec(String builderID) throws CoreException {
        IProjectDescription description = this.openLProject.getDescription();
        ICommand[] commands = description.getBuildSpec();
        for (int i = 0; i < commands.length; ++i) {
            if (!commands[i].getBuilderName().equals(builderID)) continue;
            ICommand[] newCommands = new ICommand[commands.length - 1];
            System.arraycopy(commands, 0, newCommands, 0, i);
            System.arraycopy(commands, i + 1, newCommands, i, commands.length - i - 1);
            description.setBuildSpec(newCommands);
            this.openLProject.setDescription(description, null);
            return;
        }
    }

    private void setJavaCommand(IProjectDescription description, ICommand newCommand) throws CoreException {
        ICommand[] oldBuildSpec = description.getBuildSpec();
        ICommand[] newCommands = new ICommand[oldBuildSpec.length + 1];
        System.arraycopy(oldBuildSpec, 0, newCommands, 0, oldBuildSpec.length);
        newCommands[oldBuildSpec.length] = newCommand;
        description.setBuildSpec(newCommands);
        this.openLProject.setDescription(description, null);
    }

    public void setProject(IProject project) {
        this.openLProject = project;
    }
}

