/*
 * Decompiled with CFR 0.152.
 */
package org.openl.eclipse.base;

import java.io.File;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.ClasspathVariableInitializer;
import org.eclipse.jdt.core.JavaCore;
import org.osgi.framework.Bundle;

public class PluginClasspathVariableInitializer
extends ClasspathVariableInitializer {
    static IPath getPluginHome(String pluginId) throws Exception {
        Bundle bundle = Platform.getBundle((String)pluginId);
        if (bundle == null) {
            throw new Exception("Plugin not found: " + pluginId);
        }
        URL localUrl = FileLocator.toFileURL((URL)bundle.getEntry("/"));
        String fullPath = new File(localUrl.getPath()).getAbsolutePath();
        return new Path(fullPath);
    }

    public PluginVariable decodeVariable(String encodedVariable) throws Exception {
        String varName;
        String pluginId;
        int i = encodedVariable.lastIndexOf(95);
        if (i < 0) {
            pluginId = encodedVariable;
            varName = "";
        } else {
            pluginId = encodedVariable.substring(0, i);
            varName = encodedVariable.substring(i + 1);
        }
        PluginVariable result = new PluginVariable(pluginId, varName);
        return result;
    }

    protected IProgressMonitor getProgressMonitor() {
        return null;
    }

    protected IPath getVariableValue(String variable) throws Exception {
        PluginVariable pluginVariable = this.decodeVariable(variable);
        if ("HOME".equalsIgnoreCase(pluginVariable.getName())) {
            return PluginClasspathVariableInitializer.getPluginHome(pluginVariable.getPluginId());
        }
        throw new Exception("Invalid plugin variable: " + pluginVariable);
    }

    public void initialize(String variable) {
        try {
            IPath value = this.getVariableValue(variable);
            if (value != null) {
                JavaCore.setClasspathVariable((String)variable, (IPath)value, (IProgressMonitor)this.getProgressMonitor());
            } else {
                JavaCore.removeClasspathVariable((String)variable, (IProgressMonitor)this.getProgressMonitor());
            }
        }
        catch (Throwable t) {
            System.err.println("Exception is ClasspathVariableInitializerProxy.initialize(" + variable + "): " + t.getMessage());
        }
    }

    static class PluginVariable {
        private String pluginId;
        private String name;

        public PluginVariable(String pluginId, String name) {
            this.pluginId = pluginId;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getPluginId() {
            return this.pluginId;
        }

        public String toString() {
            return "pluginId=" + this.pluginId + " varName=" + this.name;
        }
    }
}

