/*
 * Decompiled with CFR 0.152.
 */
package org.openl.eclipse.builder;

import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.openl.OpenL;
import org.openl.conf.ClassLoaderFactory;
import org.openl.conf.IUserContext;
import org.openl.conf.OpenConfigurationException;
import org.openl.conf.OpenLConfiguration;
import org.openl.conf.UserContext;
import org.openl.eclipse.builder.EclipseFileSourceCodeModule;
import org.openl.eclipse.builder.OpenlMarkers;
import org.openl.eclipse.util.Debug;
import org.openl.eclipse.util.JDTUtil;
import org.openl.eclipse.util.UrlUtil;
import org.openl.engine.OpenLManager;
import org.openl.main.OpenlMain;
import org.openl.rules.lang.xls.XlsLoader;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.exception.CompositeSyntaxNodeException;
import org.openl.types.java.JavaOpenClass;
import org.openl.util.RuntimeExceptionWrapper;

public class OpenlBuilder
extends IncrementalProjectBuilder {
    private static final String MARKER_TYPE = "org.openl.eclipse.ui.openl.problem";
    static final String[] fixedExtensions = new String[]{".openl", ".j", ".xls", ".j.science", ".dom.xml"};
    static final String openlPropertiesFname = "openl.project.classpath.properties";
    static final String openlClasspathProperty = "openl.project.classpath";
    static final int MAX_LINE_SIZE = 30;
    IUserContext userContext;

    public static IJavaProject asJavaProject(IProject project) {
        try {
            return (IJavaProject)project.getNature("org.eclipse.jdt.core.javanature");
        }
        catch (CoreException e) {
            return null;
        }
    }

    public static String getDefaultOpenlName(String fileURL) {
        return OpenlMain.getOpenlName((String)fileURL);
    }

    public static int getEndOfLineIndex(String s) {
        int len = s.length();
        int lf = s.indexOf(10);
        int cr = s.indexOf(13);
        return Math.min(cr < 0 ? len : cr, lf < 0 ? len : lf);
    }

    public static String getOpenlName(String fileURL) {
        return OpenlBuilder.getDefaultOpenlName(fileURL);
    }

    public static boolean isNotInOutputFolder(IFile file, IJavaProject jp) {
        try {
            IPath out = jp.getOutputLocation();
            return !out.isPrefixOf(file.getFullPath());
        }
        catch (JavaModelException e) {
            return true;
        }
    }

    public static boolean isOnSourcePath(IFile file) {
        IJavaProject jp = OpenlBuilder.asJavaProject(file.getProject());
        if (jp == null) {
            return true;
        }
        return jp.isOnClasspath((IResource)file) && OpenlBuilder.isNotInOutputFolder(file, jp);
    }

    public static boolean isOpenlMethod(String code) {
        int indexOfOpenl = code.indexOf("openl");
        return 0 <= indexOfOpenl && indexOfOpenl < 30 && indexOfOpenl < OpenlBuilder.getEndOfLineIndex(code);
    }

    public OpenlBuilder() {
        Debug.debug("In OpenlBuilder");
        this.intiialize();
    }

    protected void intiialize() {
        for (String ext : fixedExtensions) {
            OpenlMain.registerExtension((String)ext, (String)ext);
            OpenlMain.registerExtension((String)".xlsx", (String)".xls");
            OpenlMain.registerExtension((String)".xlsm", (String)".xls");
        }
    }

    private void addMarker(IResource resource, CompositeSyntaxNodeException se, String openl) {
        OpenlMarkers.addMarkers(resource, se, openl);
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        if (kind == 6) {
            this.fullBuild(monitor);
        } else {
            IResourceDelta delta = this.getDelta(this.getProject());
            if (delta == null) {
                this.fullBuild(monitor);
            } else {
                this.incrementalBuild(delta, monitor);
            }
        }
        return null;
    }

    void checkOpenl(IResource resource) {
        IFile file = null;
        if (!(resource instanceof IFile)) {
            return;
        }
        file = (IFile)resource;
        if (this.isOpenlExtension(file)) {
            this.deleteMarkers(file);
        }
        if (this.isOpenlFile(file)) {
            OpenL openl = null;
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            try {
                IUserContext cxt = this.getUserContext();
                Thread.currentThread().setContextClassLoader(cxt.getUserClassLoader());
                openl = this.getOpenlConfiguration(file);
                if (openl != null) {
                    OpenLManager.compileModule((OpenL)openl, (IOpenSourceCodeModule)new EclipseFileSourceCodeModule(file));
                }
            }
            catch (CompositeSyntaxNodeException se) {
                this.addMarker((IResource)file, se, openl.getName());
            }
            catch (Throwable t) {
                int severity = 2;
                OpenlMarkers.addMarker((IResource)file, file.getFullPath().toString(), "Unhandled Exception: " + t.getMessage(), severity, null, null, null);
                throw RuntimeExceptionWrapper.wrap((Throwable)t);
            }
            finally {
                Thread.currentThread().setContextClassLoader(old);
            }
        }
    }

    private void deleteMarkers(IFile file) {
        try {
            file.deleteMarkers(MARKER_TYPE, false, 0);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    protected void fullBuild(IProgressMonitor monitor) throws CoreException {
        try {
            this.resetOpenL();
            this.getProject().accept((IResourceVisitor)new OpenlResourceVisitor());
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    OpenL getOpenlConfiguration(IFile file) {
        try {
            String openlName = OpenlBuilder.getOpenlName(file.getName());
            return OpenL.getInstance((String)openlName, (IUserContext)this.getUserContext());
        }
        catch (OpenConfigurationException oce) {
            int severity = 2;
            OpenlMarkers.addMarker((IResource)file, file.getFullPath().toString(), "Openl Configuration Exception: " + oce.getMessage(), severity, null, null, null);
            return null;
        }
    }

    protected ClassLoader getProjectClassLoader() {
        String[] cp;
        try {
            cp = JDTUtil.getJavaProjectClasspath(this.getProject());
        }
        catch (Exception e) {
            throw RuntimeExceptionWrapper.wrap((Throwable)e);
        }
        return new URLClassLoader(UrlUtil.toUrl(cp), XlsLoader.class.getClassLoader());
    }

    protected String getProjectHome() {
        return this.getProject().getLocation().toString();
    }

    protected synchronized IUserContext getUserContext() {
        if (this.userContext == null) {
            this.userContext = new UserContext(this.getProjectClassLoader(), this.getProjectHome());
        }
        return this.userContext;
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        delta.accept((IResourceDeltaVisitor)new OpenlDeltaVisitor());
    }

    boolean isOpenlExtension(IFile file) {
        for (String ext : OpenlMain.getExtensionsMap().keySet()) {
            if (!file.getName().endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    boolean isOpenlFile(IFile file) {
        return this.isOpenlExtension(file) && OpenlBuilder.isOnSourcePath(file) && !this.isTempFile(file);
    }

    private boolean isTempFile(IFile file) {
        return file.getName().contains("~");
    }

    public void resetOpenL() {
        this.userContext = null;
        OpenL.reset();
        OpenLConfiguration.reset();
        HashMap old = ClassLoaderFactory.reset();
        JavaOpenClass.resetAllClassloaders((HashMap)old);
    }

    class OpenlResourceVisitor
    implements IResourceVisitor {
        OpenlResourceVisitor() {
        }

        public boolean visit(IResource resource) {
            OpenlBuilder.this.checkOpenl(resource);
            return true;
        }
    }

    class OpenlDeltaVisitor
    implements IResourceDeltaVisitor {
        OpenlDeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            switch (delta.getKind()) {
                case 1: {
                    OpenlBuilder.this.checkOpenl(resource);
                    break;
                }
                case 2: {
                    break;
                }
                case 4: {
                    OpenlBuilder.this.checkOpenl(resource);
                }
            }
            return true;
        }
    }
}

