/*
 * Decompiled with CFR 0.152.
 */
package org.openl.eclipse.builder;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.openl.eclipse.base.IOpenlModelConstants;
import org.openl.main.SourceCodeURLConstants;
import org.openl.main.SourceCodeURLTool;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.exception.CompositeSyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.util.Log;
import org.openl.util.StringTool;
import org.openl.util.text.ILocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenlMarkers
implements SourceCodeURLConstants,
IOpenlModelConstants {
    public static void addMarker(IResource resource, ILocation location, IOpenSourceCodeModule module, String openl, String message, int severity) {
        String url = SourceCodeURLTool.makeSourceLocationURL((ILocation)location, (IOpenSourceCodeModule)module, (String)openl);
        Map urlMap = SourceCodeURLTool.parseUrl((String)url);
        String start = (String)urlMap.get("start");
        String end = (String)urlMap.get("end");
        String line = (String)urlMap.get("line");
        OpenlMarkers.addMarker(resource, url, message, severity, start, end, line);
    }

    public static void addMarker(IResource resource, SyntaxNodeException error, String openl, int severity) {
        String message;
        Throwable t = error.getOriginalCause();
        if (t != null) {
            if (t instanceof CompositeSyntaxNodeException) {
                OpenlMarkers.addMarkers(resource, (CompositeSyntaxNodeException)t, openl);
                return;
            }
            message = error.getMessage();
        } else {
            message = error.getMessage();
        }
        OpenlMarkers.addMarker(resource, error.getLocation(), error.getSourceModule(), openl, message, severity);
    }

    public static void addMarker(IResource resource, String url, String message, int severity, String start, String end, String line) {
        try {
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            if (url != null) {
                attributes.put("url", url);
            }
            attributes.put("message", OpenlMarkers.toSingleLine(message));
            attributes.put("severity", new Integer(severity));
            if (start != null) {
                attributes.put("charStart", new Integer(OpenlMarkers.atoi(start, 0)));
            }
            if (end != null) {
                attributes.put("charEnd", new Integer(1 + OpenlMarkers.atoi(end, 0)));
            }
            if (line != null) {
                attributes.put("lineNumber", new Integer(OpenlMarkers.atoi(line, 0)));
            }
            OpenlMarkers.createMarker(resource, "org.openl.eclipse.ui.openl.problem", attributes);
        }
        catch (Exception e) {
            OpenlMarkers.handleException(e);
        }
    }

    public static void addMarkers(IResource resource, CompositeSyntaxNodeException sex, String openl) {
        SyntaxNodeException[] errors = sex.getErrors();
        for (int i = 0; i < errors.length; ++i) {
            OpenlMarkers.addMarker(resource, errors[i], openl, 2);
        }
    }

    public static int atoi(String a, int defaultValue) {
        try {
            return Integer.parseInt(a);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static CoreException coreException(Throwable t) {
        if (t instanceof CoreException) {
            return (CoreException)t;
        }
        if (t instanceof InvocationTargetException) {
            t = OpenlMarkers.unwrapInvocationTargetException((InvocationTargetException)t);
        }
        return new CoreException((IStatus)new MultiStatus("org.openl.eclipse.ui", 4, "Plugin Exception:", t));
    }

    protected static IMarker createMarker(IResource resource, String type, Map<String, Object> attributes) throws Exception {
        IMarker m = resource.createMarker(type);
        m.setAttributes(attributes);
        return m;
    }

    public static CoreException handleException(Throwable t) {
        CoreException ce = OpenlMarkers.coreException(t);
        Log.error((Object)ce.getStatus());
        return ce;
    }

    public static void removeAllOpenlMarkers(IResource resource) {
        boolean includeSubtypes = true;
        int depth = 2;
        try {
            resource.deleteMarkers("org.openl.eclipse.ui.openl.problem", includeSubtypes, depth);
        }
        catch (Exception e) {
            OpenlMarkers.handleException(e);
        }
    }

    public static void removeAllOpenlMarkers(IResource[] resources) {
        for (int i = 0; i < resources.length; ++i) {
            OpenlMarkers.removeAllOpenlMarkers(resources[i]);
        }
    }

    private static String toSingleLine(String s) {
        if (s == null) {
            return "";
        }
        s = StringTool.replace((String)s, (String)"\r\n", (String)". ");
        s = StringTool.replace((String)s, (String)"\n", (String)". ");
        s = StringTool.replace((String)s, (String)"\r", (String)". ");
        int MAX = 300;
        if (s.length() > MAX) {
            s = s.substring(0, MAX);
        }
        return s;
    }

    public static Throwable unwrapInvocationTargetException(InvocationTargetException t) {
        Throwable cause;
        while ((cause = t.getCause()) instanceof InvocationTargetException) {
            t = (InvocationTargetException)cause;
        }
        return cause != null ? cause : t;
    }
}

