/*
 * Decompiled with CFR 0.152.
 */
package org.openl.eclipse.internal.ide.extension;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IFileEditorMapping;
import org.openl.eclipse.ide.extension.IOpenlBuilderExtension;
import org.openl.eclipse.ide.extension.IOpenlExtensionManager;
import org.openl.eclipse.ide.extension.IOpenlLanguageExtension;
import org.openl.eclipse.internal.ide.extension.OpenlBuilderExtension;
import org.openl.eclipse.internal.ide.extension.OpenlLanguageExtension;
import org.openl.eclipse.util.UtilBase;
import org.openl.eclipse.util.XxY;
import org.openl.util.AOpenIterator;
import org.openl.util.IConvertor;

public class ExtensionManager
extends UtilBase
implements IOpenlExtensionManager {
    protected Map pluginDescriptors = new HashMap();

    public ExtensionManager() {
        this.register();
    }

    public Properties getAllOpenlExtensionsProperties() {
        Properties result = new Properties();
        IOpenlLanguageExtension[] langs = this.getOpenlLanguageExtensions();
        for (int i = 0; i < langs.length; ++i) {
            result.putAll((Map<?, ?>)langs[i].getProperties());
        }
        IOpenlBuilderExtension[] builderExts = this.getOpenlBuilderExtensions();
        for (int i = 0; i < builderExts.length; ++i) {
            result.putAll((Map<?, ?>)builderExts[i].getProperties());
        }
        return result;
    }

    XxY getEclipseFileEditorMapping() {
        XxY m = new XxY();
        IFileEditorMapping[] mappings = this.getEditorRegistry().getFileEditorMappings();
        for (int i = 0; i < mappings.length; ++i) {
            String file = mappings[i].getExtension();
            IEditorDescriptor[] editorDescriptors = mappings[i].getEditors();
            for (int j = 0; j < editorDescriptors.length; ++j) {
                String editor = editorDescriptors[j].getId();
                m.add(file, editor);
            }
        }
        return m;
    }

    IExtensionRegistry getExtensionRegistry() {
        return Platform.getExtensionRegistry();
    }

    Collection getExtensions(String extensionPointId, IConvertor collector) {
        ArrayList<IConfigurationElement> result = new ArrayList<IConfigurationElement>();
        IExtensionPoint point = this.getExtensionRegistry().getExtensionPoint(extensionPointId);
        if (point != null) {
            IExtension[] extensions = point.getExtensions();
            for (int i = 0; i < extensions.length; ++i) {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                for (int j = 0; j < elements.length; ++j) {
                    result.add(elements[j]);
                }
            }
        }
        return AOpenIterator.collect(result.iterator(), (IConvertor)collector).asList();
    }

    public XxY getFileEditorMapping() {
        XxY m = new XxY();
        IOpenlLanguageExtension[] extensions = this.getOpenlLanguageExtensions();
        for (int i = 0; i < extensions.length; ++i) {
            m.add(extensions[i].getFileEditorMapping());
        }
        return m;
    }

    public XxY getFileOpenlMapping() {
        XxY m = new XxY();
        IOpenlLanguageExtension[] extensions = this.getOpenlLanguageExtensions();
        for (int i = 0; i < extensions.length; ++i) {
            m.add(extensions[i].getFileOpenlMapping());
        }
        return m;
    }

    public IOpenlBuilderExtension[] getOpenlBuilderExtensions() {
        IConvertor collector = new IConvertor(){

            public Object convert(Object o) {
                IConfigurationElement el = (IConfigurationElement)o;
                return new OpenlBuilderExtension(el);
            }
        };
        return this.getExtensions("org.openl.eclipse.ui.builderConfiguration", collector).toArray(NO_BUILDER_EXTENSIONS);
    }

    public IOpenlLanguageExtension[] getOpenlLanguageExtensions() {
        IConvertor collector = new IConvertor(){

            public Object convert(Object o) {
                IConfigurationElement el = (IConfigurationElement)o;
                return new OpenlLanguageExtension(el);
            }
        };
        return this.getExtensions("org.openl.eclipse.ui.languageConfiguration", collector).toArray(NO_LANGUAGE_EXTENSIONS);
    }

    void register() {
        this.registerEditors(this.getFileEditorMapping());
    }

    void registerEditors(XxY requiredMapping) {
    }
}

