/*
 * Decompiled with CFR 0.152.
 */
package org.openl.eclipse.launch;

import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.openl.eclipse.launch.LaunchBase;
import org.openl.eclipse.util.ResourceUtil;
import org.openl.main.SourceCodeURLConstants;
import org.openl.main.SourceCodeURLTool;

public abstract class AConsoleHyperlink
extends LaunchBase
implements IHyperlink,
SourceCodeURLConstants {
    protected IConsole console;
    protected String url;

    public AConsoleHyperlink(IConsole console, String url) {
        this.console = console;
        this.url = url;
    }

    protected void activateTextEditor(String url) throws Exception {
        Map urlMap = SourceCodeURLTool.parseUrl((String)url);
        String fileName = (String)urlMap.get("file");
        IEditorPart sourceEditor = this.getSourceEditor(fileName);
        if (!(sourceEditor instanceof ITextEditor)) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)this.getString("Information"), (String)this.getString("Source_not_found"));
            return;
        }
        ITextEditor textEditor = (ITextEditor)this.getSourceEditor(fileName);
        int start = AConsoleHyperlink.atoi((String)urlMap.get("start"), 0);
        int end = AConsoleHyperlink.atoi((String)urlMap.get("end"), start);
        textEditor.selectAndReveal(start, end - start + 1);
    }

    protected IConsole getConsole() {
        return this.console;
    }

    private String getEditorId(IFile file) {
        IWorkbench workbench = this.getWorkbench();
        IEditorDescriptor desc = workbench.getEditorRegistry().getDefaultEditor(file.getName());
        if (desc == null) {
            desc = workbench.getEditorRegistry().findEditor("org.eclipse.ui.systemExternalEditor");
        }
        return desc.getId();
    }

    private IEditorPart getSourceEditor(String fileName) {
        IWorkbenchPage page;
        IWorkbenchWindow window = AConsoleHyperlink.getActiveWorkbenchWindow();
        IResource resource = ResourceUtil.findWorkspaceResource(fileName);
        if (resource == null || !(resource instanceof IFile)) {
            return null;
        }
        IFile file = (IFile)resource;
        if (window != null && (page = window.getActivePage()) != null) {
            try {
                IEditorPart editorPart = page.openEditor((IEditorInput)new FileEditorInput(file), this.getEditorId(file), false);
                return editorPart;
            }
            catch (PartInitException e) {
                AConsoleHyperlink.getLogPlugin().getLog().log((IStatus)new Status(4, "org.openl.eclipse.ui", 0, e.getMessage(), (Throwable)e));
            }
        }
        return null;
    }

    public void linkEntered() {
    }

    public void linkExited() {
    }
}

