/*
 * Decompiled with CFR 0.152.
 */
package org.openl.eclipse.launch;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.openl.eclipse.launch.ILaunchRequest;
import org.openl.eclipse.launch.ILaunchTarget;
import org.openl.eclipse.launch.LaunchBase;
import org.openl.eclipse.launch.LaunchRequest;
import org.openl.eclipse.util.Debug;
import org.openl.eclipse.util.XxY;
import org.openl.util.ASelector;
import org.openl.util.IConvertor;
import org.openl.util.ISelector;

public abstract class ALaunchShortcut
extends LaunchBase
implements ILaunchShortcut {
    public abstract IConvertor asLaunchTarget();

    public ILaunchConfiguration[] chooseLaunchConfigurations(ILaunchRequest request, ILaunchConfiguration[] launchConfigurations, boolean multipleSelection) {
        return (ILaunchConfiguration[])this.selectionDialog(launchConfigurations, this.getString("Launch_Configuration_Selection"), this.getFormattedString("Choose_launch_configuration_to_{0}", request.getLaunchMode()), multipleSelection);
    }

    public ILaunchTarget[] chooseLaunchTargets(ILaunchRequest request, ILaunchTarget[] launchTargets, boolean multipleSelection) {
        Object[] res = this.selectionDialog(launchTargets, this.getString("Launch_Target_Selection"), this.getFormattedString("Choose_launch_target_to_{0}", request.getLaunchMode()), multipleSelection);
        ILaunchTarget[] resL = new ILaunchTarget[res.length];
        for (int i = 0; i < res.length; ++i) {
            resL[i] = (ILaunchTarget)res[i];
        }
        return resL;
    }

    public ILaunchRequest createLaunchRequest(IEditorPart editor, String mode) {
        return new LaunchRequest(editor, mode);
    }

    public ILaunchRequest createLaunchRequest(ISelection selection, String mode) {
        return selection instanceof IStructuredSelection ? new LaunchRequest((IStructuredSelection)selection, mode) : null;
    }

    protected ILaunchConfiguration[] getExistingLaunchConfigurations(ILaunchRequest request, ILaunchTarget[] targets) {
        try {
            return this.getLaunchConfigurations().select(this.launchConfigurationForTargets(targets).and(this.launchConfigurationSupportsMode(request.getLaunchMode()))).asList().toArray(NO_CONFIGURATIONS);
        }
        catch (CoreException e) {
            this.handleException(e);
            return NO_CONFIGURATIONS;
        }
    }

    ILaunchGroup getLaunchConfigurationGroup(ILaunchConfiguration configuration, ILaunchRequest request) {
        ILaunchGroup group = DebugUITools.getLaunchGroup((ILaunchConfiguration)configuration, (String)request.getLaunchMode());
        if (group == null) {
            throw new InternalError("LaunchConfigurationManager.getDefaultLanuchGroup() returns null");
        }
        return group;
    }

    protected ILaunchConfiguration[] getLaunchConfigurations(ILaunchRequest request, ILaunchTarget[] targets) {
        int i;
        ILaunchConfiguration[] configurations = this.getExistingLaunchConfigurations(request, targets);
        XxY tc = new XxY();
        for (i = 0; i < targets.length; ++i) {
            for (int j = 0; j < configurations.length; ++j) {
                if (!targets[i].isLaunchedBy(configurations[j])) continue;
                tc.add(targets[i], configurations[j]);
            }
        }
        if (tc.x_Y().isF()) {
            for (i = 0; i < targets.length; ++i) {
                if (tc.x_Y().X().contains(targets[i])) continue;
                ILaunchConfiguration configuration = targets[i].createDefaultLaunchConfiguration(request);
                if (configuration == null) {
                    return null;
                }
                tc.add(targets[i], configuration);
            }
            configurations = tc.y_X().X().toArray(NO_CONFIGURATIONS);
        } else {
            configurations = this.chooseLaunchConfigurations(request, configurations, false);
        }
        if (configurations != null && configurations.length == 0) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)this.getString("Launch_failed"), (String)this.getString(this.MSG_NO_CONFIGURATIONS_TO_LAUNCH(request)));
        }
        return configurations != null ? configurations : NO_CONFIGURATIONS;
    }

    public ILaunchTarget[] getLaunchTargets(ILaunchRequest request) {
        ILaunchTarget[] targets = request.getSelection().select(this.selectLaunchTargetType()).collect(this.asLaunchTarget()).select(NOT_NULLS).asList().toArray(NO_TARGETS);
        if (targets.length == 0) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)this.getString("Launch_failed"), (String)this.getString(this.MSG_NO_TARGETS_TO_LAUNCH(request)));
        } else if (targets.length > 1) {
            targets = this.chooseLaunchTargets(request, targets, false);
        }
        return targets != null ? targets : NO_TARGETS;
    }

    public void launch(IEditorPart activeEditor, String mode) {
        this.launch(this.createLaunchRequest(activeEditor, mode));
    }

    boolean launch(ILaunchConfiguration configuration, ILaunchRequest request, boolean preview) {
        if (preview && !this.previewConfiguration(configuration, request)) {
            return false;
        }
        Debug.debug("Launching: " + configuration.getName());
        DebugUITools.launch((ILaunchConfiguration)configuration, (String)request.getLaunchMode());
        return true;
    }

    public void launch(ILaunchRequest request) {
        boolean ok;
        ILaunchTarget[] targets = NO_TARGETS;
        ILaunchConfiguration[] configurations = NO_CONFIGURATIONS;
        boolean bl = ok = DebugUITools.saveAndBuildBeforeLaunch() && (targets = this.getLaunchTargets(request)).length > 0 && (configurations = this.getLaunchConfigurations(request, targets)).length > 0;
        if (!ok) {
            return;
        }
        for (int i = 0; i < configurations.length; ++i) {
            boolean preview = true;
            if (this.launch(configurations[i], request, preview)) continue;
            return;
        }
    }

    public void launch(ISelection selection, String mode) {
        this.launch(this.createLaunchRequest(selection, mode));
    }

    public ISelector launchConfigurationForTarget(final ILaunchTarget target) {
        return new ASelector(){

            public boolean select(Object o) {
                return o instanceof ILaunchConfiguration && target.isLaunchedBy((ILaunchConfiguration)o);
            }
        };
    }

    public ISelector launchConfigurationForTargets(ILaunchTarget[] targets) {
        ISelector result = FALSE_SELECTOR;
        for (int i = 0; i < targets.length; ++i) {
            result = result.or(this.launchConfigurationForTarget(targets[i]));
        }
        return result;
    }

    boolean previewConfiguration(ILaunchConfiguration configuration, ILaunchRequest request) {
        String groupId = this.getLaunchConfigurationGroup(configuration, request).getIdentifier();
        return DebugUITools.openLaunchConfigurationPropertiesDialog((Shell)this.getShell(), (ILaunchConfiguration)configuration, (String)groupId) == 0;
    }

    public abstract ISelector selectLaunchTargetType();
}

