/*
 * Decompiled with CFR 0.152.
 */
package org.openl.eclipse.launch;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.jface.text.IRegion;
import org.openl.eclipse.launch.IHyperlinkFactory;
import org.openl.eclipse.util.StringMatcher;

public class ConsoleLineTrackerTool {
    public static final int DEFAULT_PRIORITY = 100;
    protected static List ALL = new ArrayList();
    protected IConsole console;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static HyperlinkHandlerInfo getInfo(String text) {
        List list = ALL;
        synchronized (list) {
            for (int i = 0; i < ALL.size(); ++i) {
                HyperlinkHandlerInfo info = (HyperlinkHandlerInfo)ALL.get(i);
                if (!info.includeMatcher.match(text) || info.excludeMatcher != null && info.excludeMatcher.match(text)) continue;
                return info;
            }
            return null;
        }
    }

    protected static String getUrl(String s) {
        if (s.startsWith("    at ")) {
            return s.substring("    at ".length());
        }
        return null;
    }

    public static void lineAppended(IConsole console, IRegion line) {
        try {
            int textOffset = line.getOffset();
            int textLength = line.getLength();
            String text = console.getDocument().get(textOffset, textLength);
            HyperlinkHandlerInfo info = ConsoleLineTrackerTool.getInfo(text);
            String url = ConsoleLineTrackerTool.getUrl(text);
            if (info == null || url == null) {
                return;
            }
            console.addLink(info.factory.createHyperlink(console, url), textOffset, textLength);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(IHyperlinkFactory factory, String matchIncludeString, String matchExcludeString, int priority) {
        List list = ALL;
        synchronized (list) {
            int i;
            for (i = 0; i < ALL.size(); ++i) {
                HyperlinkHandlerInfo info = (HyperlinkHandlerInfo)ALL.get(i);
                if (priority >= info.priority) break;
            }
            ALL.add(i, new HyperlinkHandlerInfo(factory, matchIncludeString, matchExcludeString, priority));
        }
    }

    static class HyperlinkHandlerInfo {
        IHyperlinkFactory factory;
        int priority;
        StringMatcher includeMatcher;
        StringMatcher excludeMatcher;

        HyperlinkHandlerInfo(IHyperlinkFactory factory, String matchIncludeString, String matchExcludeString, int priority) {
            this.factory = factory;
            this.priority = priority;
            this.includeMatcher = new StringMatcher(matchIncludeString, false, false);
            if (matchExcludeString != null) {
                this.excludeMatcher = new StringMatcher(matchExcludeString, false, false);
            }
        }
    }
}

