/*
 * Decompiled with CFR 0.152.
 */
package org.openl.eclipse.launch;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.openl.eclipse.launch.ILaunchBase;
import org.openl.eclipse.launch.ILaunchRequest;
import org.openl.eclipse.util.UtilBase;
import org.openl.util.ASelector;
import org.openl.util.IOpenIterator;
import org.openl.util.ISelector;
import org.openl.util.OpenIterator;

public class LaunchBase
extends UtilBase
implements ILaunchBase {
    public IOpenIterator getLaunchConfigurations() throws CoreException {
        return OpenIterator.fromArray((Object[])this.getLaunchManager().getLaunchConfigurations());
    }

    public ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    public ISelector launchConfigurationSupportsMode(final String mode) {
        return new ASelector(){

            public boolean select(Object o) {
                try {
                    return ((ILaunchConfiguration)o).supportsMode(mode);
                }
                catch (Exception e) {
                    LaunchBase.this.handleException(e);
                    return false;
                }
            }
        };
    }

    public String MSG_NO_CONFIGURATIONS_TO_LAUNCH(ILaunchRequest selection) {
        return "No_configurations_to_" + selection.getLaunchMode();
    }

    public String MSG_NO_TARGETS_TO_LAUNCH(ILaunchRequest selection) {
        return "No_targets_in_" + (selection.isFromEditor() ? "active_editor" : "selection") + "_to_" + selection.getLaunchMode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] selectionDialog(Object[] elements, String title, String message, boolean multi) {
        IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
        try {
            ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
            dialog.setTitle(title);
            dialog.setMessage(message);
            dialog.setElements(elements);
            dialog.setMultipleSelection(multi);
            dialog.open();
            Object[] objectArray = dialog.getResult();
            return objectArray;
        }
        finally {
            labelProvider.dispose();
        }
    }

    public String uniqueLCName(String prefix) {
        return this.getLaunchManager().generateUniqueLaunchConfigurationNameFrom(prefix);
    }
}

