/*
 * Decompiled with CFR 0.152.
 */
package org.openl.eclipse.launch;

import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.debug.ui.console.IConsoleLineTracker;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.console.IHyperlink;
import org.openl.eclipse.launch.ConsoleLineTrackerTool;
import org.openl.eclipse.launch.IHyperlinkFactory;
import org.openl.eclipse.launch.OpenlStackTraceHyperlink;
import org.openl.main.SourceCodeURLConstants;

public class OpenlConsoleTracker
implements IConsoleLineTracker,
IHyperlinkFactory,
SourceCodeURLConstants {
    private boolean isRegistered = false;
    private IConsole console;

    public IHyperlink createHyperlink(IConsole console, String url) {
        return new OpenlStackTraceHyperlink(console, url);
    }

    public void dispose() {
    }

    public String getExcludeMatchString() {
        return "*.xls*";
    }

    public String getIncludeMatchString() {
        return "    at *";
    }

    public synchronized void init(IConsole console) {
        this.console = console;
        if (!this.isRegistered) {
            ConsoleLineTrackerTool.register(this, this.getIncludeMatchString(), this.getExcludeMatchString(), 100);
            this.isRegistered = true;
        }
    }

    public void lineAppended(IRegion line) {
        ConsoleLineTrackerTool.lineAppended(this.console, line);
    }
}

