/*
 * Decompiled with CFR 0.152.
 */
package org.openl.eclipse.launch;

import java.util.Enumeration;
import java.util.Properties;
import org.eclipse.core.resources.IResource;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.openl.eclipse.builder.OpenlBuilder;
import org.openl.eclipse.launch.ALaunchTarget;
import org.openl.eclipse.launch.ILaunchRequest;
import org.openl.eclipse.util.UrlUtil;
import org.openl.main.OpenlMain;

public class OpenlLaunchTarget
extends ALaunchTarget {
    protected IResource source;

    public OpenlLaunchTarget(IResource source) {
        this.source = source;
    }

    public boolean equals(Object o) {
        if (!(o instanceof OpenlLaunchTarget)) {
            return false;
        }
        OpenlLaunchTarget that = (OpenlLaunchTarget)o;
        return this.source.equals(that.source);
    }

    public String generateUniqueLaunchConfigurationName() {
        String prefix = this.source.getName();
        return this.getLaunchManager().generateUniqueLaunchConfigurationNameFrom(prefix);
    }

    public String getCanonicalURL(IResource resource) {
        String url = resource.getLocation().toString();
        return UrlUtil.toCanonicalUrl(url);
    }

    public String getDefaultLaunchConfigurationTypeID() {
        return IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION;
    }

    public String getJavaVMArgs() {
        StringBuffer s = new StringBuffer();
        Properties properties = new Properties();
        Enumeration<?> it = properties.propertyNames();
        while (it.hasMoreElements()) {
            String key = (String)it.nextElement();
            String value = properties.getProperty(key);
            s.append(" -D").append(key).append("=").append(value);
        }
        return s.toString();
    }

    public String getOpenlName() {
        return OpenlBuilder.getOpenlName(this.getSourceFileName());
    }

    public String getSourceFileName() {
        String sourceFileName = this.getCanonicalURL(this.source);
        return sourceFileName;
    }

    public int hashCode() {
        return this.source.hashCode();
    }

    public void initDefaultLaunchConfiguration(ILaunchConfigurationWorkingCopy wc, ILaunchRequest request) throws Exception {
        OpenlMain main = new OpenlMain(this.getOpenlName());
        this.setOpenlMainArgs(main);
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, main.getClass().getName());
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, main.makeArgs());
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, this.getJavaVMArgs());
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, this.source.getProject().getName());
    }

    public boolean isLaunchedBy(ILaunchConfiguration c) {
        try {
            String project = this.source.getProject().getName();
            String sourceUrl = this.getCanonicalURL(this.source);
            String attrMain = c.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, "");
            String attrProject = c.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
            String attrArgs = c.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, "");
            return project.equals(attrProject) && OpenlMain.class.getName().equals(attrMain) && attrArgs.indexOf(sourceUrl) >= 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setOpenlMainArgs(OpenlMain main) {
        main.sourceFileName = this.getSourceFileName();
    }

    public String toString() {
        return this.source.toString();
    }
}

