/*
 * Decompiled with CFR 0.152.
 */
package org.openl.eclipse.launch;

import org.eclipse.core.resources.IResource;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.openl.eclipse.launch.ALaunchTarget;
import org.openl.eclipse.launch.ILaunchRequest;
import org.openl.eclipse.launch.OpenlLaunchTarget;
import org.openl.main.OpenlMain;

public class OpenlModuleLaunchTarget
extends ALaunchTarget {
    OpenlLaunchTarget module;
    String methodName;

    public OpenlModuleLaunchTarget(IResource source, String methodName) {
        this.module = new OpenlLaunchTarget(source);
        this.methodName = methodName;
    }

    public boolean equals(Object o) {
        if (!(o instanceof OpenlModuleLaunchTarget)) {
            return false;
        }
        OpenlModuleLaunchTarget that = (OpenlModuleLaunchTarget)o;
        return this.module.equals(that.module) && this.methodName.equals(that.methodName);
    }

    public String generateUniqueLaunchConfigurationName() {
        return this.module.generateUniqueLaunchConfigurationName();
    }

    public String getDefaultLaunchConfigurationTypeID() {
        return this.module.getDefaultLaunchConfigurationTypeID();
    }

    public int hashCode() {
        return this.module.hashCode() + this.methodName.hashCode();
    }

    public void initDefaultLaunchConfiguration(ILaunchConfigurationWorkingCopy wc, ILaunchRequest request) throws Exception {
        this.module.initDefaultLaunchConfiguration(wc, request);
        OpenlMain main = new OpenlMain(this.module.getOpenlName());
        this.module.setOpenlMainArgs(main);
        main.methodName = this.methodName;
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, main.makeArgs());
    }

    public boolean isLaunchedBy(ILaunchConfiguration c) {
        if (!this.module.isLaunchedBy(c)) {
            return false;
        }
        try {
            String attrArgs = c.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, "");
            return attrArgs.indexOf(" " + this.methodName + " ") >= 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String toString() {
        return this.module.toString() + this.methodName + "()";
    }
}

