/*
 * Decompiled with CFR 0.152.
 */
package org.openl.eclipse.util;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.openl.eclipse.util.ResourceUtil;

public class JDTUtil {
    /*
     * Enabled aggressive block sorting
     */
    private static void addJavaLibraries(IJavaProject javaProject, Collection classpath, boolean exportedOnly) throws Exception {
        IPath defaultOutputLocation = javaProject.getOutputLocation();
        IClasspathEntry[] classpathEntries = javaProject.getResolvedClasspath(true);
        int i = 0;
        while (true) {
            block8: {
                String path2;
                if (i >= classpathEntries.length) {
                    return;
                }
                IPath path = null;
                switch (classpathEntries[i].getEntryKind()) {
                    case 1: {
                        if (!exportedOnly || classpathEntries[i].isExported()) {
                            path = classpathEntries[i].getPath();
                            break;
                        }
                        break block8;
                    }
                    case 3: {
                        path = classpathEntries[i].getOutputLocation();
                        if (path != null) break;
                        path = defaultOutputLocation;
                    }
                }
                if (path != null && !classpath.contains(path2 = ResourceUtil.toCanonicalUrl((IContainer)javaProject.getProject(), path))) {
                    classpath.add(path2);
                }
            }
            ++i;
        }
    }

    private static void addRequiredJavaProjectNames(String projectName, Collection projects, boolean exportedOnly) throws Exception {
        if (projects.contains(projectName)) {
            return;
        }
        projects.add(projectName);
        IJavaProject javaProject = JDTUtil.getJavaProject(projectName);
        if (javaProject == null) {
            return;
        }
        boolean ignoreUnresolvedEntry = true;
        IClasspathEntry[] classpathEntries = javaProject.getResolvedClasspath(ignoreUnresolvedEntry);
        block3: for (int i = 0; i < classpathEntries.length; ++i) {
            switch (classpathEntries[i].getEntryKind()) {
                case 2: {
                    if (exportedOnly && !classpathEntries[i].isExported()) continue block3;
                    String requiredProjectName = classpathEntries[i].getPath().lastSegment();
                    boolean exportedOnlyForNonRootProject = true;
                    JDTUtil.addRequiredJavaProjectNames(requiredProjectName, projects, exportedOnlyForNonRootProject);
                }
            }
        }
    }

    public static IJavaProject getJavaProject(IProject project) {
        try {
            return (IJavaProject)project.getNature("org.eclipse.jdt.core.javanature");
        }
        catch (Exception e) {
            System.err.println(e);
            return null;
        }
    }

    public static IJavaProject getJavaProject(String projectName) {
        try {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            return project == null ? null : JDTUtil.getJavaProject(project);
        }
        catch (Exception e) {
            System.err.println(e);
            return null;
        }
    }

    public static String[] getJavaProjectClasspath(IProject project) throws Exception {
        ArrayList projects = new ArrayList();
        ArrayList classpath = new ArrayList();
        JDTUtil.addRequiredJavaProjectNames(project.getName(), projects, false);
        boolean isRootProject = true;
        for (String projectName : projects) {
            IJavaProject javaProject = JDTUtil.getJavaProject(projectName);
            if (javaProject == null) continue;
            boolean exportedOnly = !isRootProject;
            JDTUtil.addJavaLibraries(javaProject, classpath, exportedOnly);
            isRootProject = false;
        }
        return classpath.toArray(new String[classpath.size()]);
    }
}

