/*
 * Decompiled with CFR 0.152.
 */
package org.openl.eclipse.util;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.openl.eclipse.util.UrlUtil;

public class ResourceUtil {
    public static IResource findResource(IPath path, IContainer parent) {
        if (path.isAbsolute()) {
            parent = ResourcesPlugin.getWorkspace().getRoot();
        }
        IResource resource = parent.findMember(path);
        return resource;
    }

    public static IResource findWorkspaceResource(IPath path) {
        IWorkspaceRoot ws = ResourcesPlugin.getWorkspace().getRoot();
        IPath wsPath = ws.getLocation();
        if (wsPath.isPrefixOf(path)) {
            path = path.removeFirstSegments(wsPath.segmentCount());
            path = path.setDevice(null);
        }
        return ws.findMember(path);
    }

    public static IResource findWorkspaceResource(String url) {
        url = ResourceUtil.normalizeFile(url);
        return ResourceUtil.findWorkspaceResource((IPath)new Path(url));
    }

    public static IProject getProject(String projectName) {
        return (IProject)ResourceUtil.getWorkspaceRoot().findMember(projectName);
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static IWorkspaceRoot getWorkspaceRoot() {
        return ResourceUtil.getWorkspace().getRoot();
    }

    private static String normalizeFile(String s) {
        if (s.indexOf(47) == 0) {
            s = s.substring(1);
        }
        return s;
    }

    public static String toCanonicalUrl(IContainer parent, IPath path) {
        IResource resource = ResourceUtil.findResource(path, parent);
        if (resource != null) {
            path = resource.getLocation();
        }
        return UrlUtil.toCanonicalUrl(path.toString());
    }
}

