/*
 * Decompiled with CFR 0.152.
 */
package org.openl.eclipse.util;

import java.io.File;
import java.net.URL;
import org.openl.util.RuntimeExceptionWrapper;

public class UrlUtil {
    public static final String FILE_PROTOCOL = "file:";

    private static URL guessFileURL(String url) {
        int idx = (url = UrlUtil.ltrimFileURL(url)).indexOf(58);
        if (idx == 0 || idx > 1) {
            return null;
        }
        try {
            return new File(url).getCanonicalFile().toURL();
        }
        catch (Exception e) {
            throw RuntimeExceptionWrapper.wrap((Throwable)e);
        }
    }

    private static String ltrimFileURL(String url) {
        if ((url = url.replace('\\', '/')).startsWith(FILE_PROTOCOL)) {
            url = url.substring(FILE_PROTOCOL.length());
        }
        if (url.indexOf(47) == 0 && url.indexOf(58) == 2) {
            url = url.substring(1);
        }
        return url;
    }

    public static String toCanonicalUrl(String path) {
        String url = UrlUtil.toUrl(path).toExternalForm();
        url = UrlUtil.ltrimFileURL(url);
        return url;
    }

    public static String toCanonicalUrl(String parent, String child) {
        String url = UrlUtil.toCanonicalUrl(parent);
        if (child != null && child.length() > 0) {
            url = url + '/' + child;
        }
        return url;
    }

    public static URL toUrl(String path) {
        URL url = UrlUtil.guessFileURL(path);
        if (url != null) {
            return url;
        }
        try {
            return new URL(path);
        }
        catch (Exception e) {
            throw RuntimeExceptionWrapper.wrap((Throwable)e);
        }
    }

    public static URL[] toUrl(String[] path) {
        URL[] result = new URL[path.length];
        for (int i = 0; i < path.length; ++i) {
            result[i] = UrlUtil.toUrl(path[i]);
        }
        return result;
    }
}

