/*
 * Decompiled with CFR 0.152.
 */
package org.openl.eclipse.util;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IDecoratorManager;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.openl.eclipse.base.OpenlBasePlugin;
import org.openl.eclipse.builder.OpenlBuilder;
import org.openl.eclipse.util.IUtilBase;
import org.openl.eclipse.util.ResourceUtil;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.util.ASelector;
import org.openl.util.ISelector;
import org.openl.util.RuntimeExceptionWrapper;

public class UtilBase
implements IUtilBase {
    protected String resourceBundleName;
    protected ResourceBundle resourceBundle;

    private static void appendErrorMessage(StringBuffer sb, String s) {
        if (s != null && s.trim().length() > 0) {
            if (sb.length() > 0) {
                sb.append(": ");
            }
            sb.append(s);
        }
    }

    public static int atoi(String a, int defaultValue) {
        try {
            return Integer.parseInt(a);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return OpenlBasePlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static Plugin getLogPlugin() {
        return OpenlBasePlugin.getDefault();
    }

    protected void append(StringBuffer sb, String s) {
        if (s != null && s.trim().length() > 0) {
            if (sb.length() > 0) {
                sb.append(": ");
            }
            sb.append(s);
        }
    }

    public CoreException coreException(String message) {
        return this.coreException(message, null, -1, 4);
    }

    public CoreException coreException(String message, Throwable t, int code, int severity) {
        return new CoreException((IStatus)new Status(severity, OpenlBasePlugin.getDefault().getBundle().getSymbolicName(), code, this.getMessage(t), t));
    }

    public CoreException coreException(Throwable t) {
        if (t instanceof CoreException) {
            return (CoreException)t;
        }
        if (t instanceof InvocationTargetException) {
            t = this.unwrapInvocationTargetException((InvocationTargetException)t);
        }
        return this.coreException(null, t, -1, 4);
    }

    public IDecoratorManager getDecoratorManager() {
        return this.getWorkbench().getDecoratorManager();
    }

    public String getDefaultResourceBundleName() {
        return this.getClass().getPackage().getName() + '.' + "Messages";
    }

    public IEditorRegistry getEditorRegistry() {
        return this.getWorkbench().getEditorRegistry();
    }

    public String getFormattedString(String key, Object arg) {
        return this.getFormattedString(key, new Object[]{arg});
    }

    public String getFormattedString(String key, Object[] args) {
        return MessageFormat.format(this.getString(key), args);
    }

    public String getMessage(SyntaxNodeException error) {
        StringBuffer sb = new StringBuffer();
        UtilBase.appendErrorMessage(sb, error.getMessage());
        UtilBase.appendErrorMessage(sb, this.getMessage(error.getOriginalCause()));
        return sb.toString();
    }

    public String getMessage(Throwable t) {
        StringBuffer sb = new StringBuffer();
        this.append(sb, t.getMessage());
        if (sb.length() == 0) {
            this.append(sb, t.getClass().getName() + ": NO_MESSAGE");
        }
        return sb.toString();
    }

    public IResource getResourceAdapter(IAdaptable adaptable) {
        if (adaptable instanceof IJavaElement) {
            try {
                return ((IJavaElement)adaptable).getCorrespondingResource();
            }
            catch (Exception e) {
                this.handleException(e);
                return null;
            }
        }
        if (adaptable instanceof IStorageEditorInput) {
            try {
                return this.getResourceAdapter((IAdaptable)((IStorageEditorInput)adaptable).getStorage());
            }
            catch (Exception e) {
                this.handleException(e);
                return null;
            }
        }
        if (adaptable instanceof IStorage) {
            return ResourceUtil.findWorkspaceResource(((IStorage)adaptable).getFullPath());
        }
        if (adaptable instanceof IEditorPart) {
            return this.getResourceAdapter((IAdaptable)((IEditorPart)adaptable).getEditorInput());
        }
        Object adapter = adaptable.getAdapter(IFile.class);
        if (adapter == null) {
            adapter = adaptable.getAdapter(IResource.class);
        }
        if (!(adapter instanceof IResource)) {
            return null;
        }
        IResource res = (IResource)adapter;
        return res;
    }

    public IResource getResourceAdapter(Object something) {
        if (something instanceof IResource) {
            return (IResource)something;
        }
        if (something instanceof IAdaptable) {
            return this.getResourceAdapter((IAdaptable)something);
        }
        return null;
    }

    public ResourceBundle getResourceBundle() {
        if (this.resourceBundle == null) {
            this.resourceBundle = this.loadResourceBundle();
        }
        return this.resourceBundle;
    }

    public String getResourceBundleName() {
        return this.resourceBundleName != null ? this.resourceBundleName : this.getDefaultResourceBundleName();
    }

    public Shell getShell() {
        if (UtilBase.getActiveWorkbenchWindow() != null) {
            return UtilBase.getActiveWorkbenchWindow().getShell();
        }
        return null;
    }

    public String getString(String key) {
        return this.getString(key, key);
    }

    public String getString(String key, String defaultValue) {
        String result = null;
        try {
            result = this.getResourceBundle().getString(key);
        }
        catch (Throwable t) {
            this.handleException(t);
        }
        return result != null ? result : defaultValue;
    }

    public IWorkbench getWorkbench() {
        return PlatformUI.getWorkbench();
    }

    public CoreException handleException(String message) {
        CoreException ce = this.coreException(message);
        this.log(ce.getStatus());
        return ce;
    }

    public CoreException handleException(Throwable t) {
        CoreException ce = this.coreException(t);
        this.log(ce.getStatus());
        return ce;
    }

    public RuntimeException handleException1(Throwable t) {
        return RuntimeExceptionWrapper.wrap((Throwable)this.handleException(t));
    }

    public boolean isParentChild(IResource parent, IResource child) {
        for (IResource res = child; res != null; res = res.getParent()) {
            if (!res.equals(parent)) continue;
            return true;
        }
        return false;
    }

    public boolean isParentChild(IResource[] parents, IResource child) {
        for (int i = 0; i < parents.length; ++i) {
            if (!this.isParentChild(parents[i], child)) continue;
            return true;
        }
        return false;
    }

    public ResourceBundle loadResourceBundle() {
        try {
            String bundleName = this.getResourceBundleName();
            Locale locale = Locale.getDefault();
            ClassLoader cl = this.getClass().getClassLoader();
            return ResourceBundle.getBundle(bundleName, locale, cl);
        }
        catch (Throwable t) {
            throw this.handleException1(t);
        }
    }

    public void log(IStatus status) {
        UtilBase.getLogPlugin().getLog().log(status);
    }

    public ISelector selectByPath() {
        return new ASelector(){

            public boolean select(Object o) {
                IResource resource = UtilBase.this.getResourceAdapter(o);
                return resource != null && resource instanceof IFile && OpenlBuilder.isOnSourcePath((IFile)resource);
            }
        };
    }

    public ISelector selectByPathOld(final IResource[] roots) {
        return new ASelector(){

            public boolean select(Object o) {
                IResource resource = UtilBase.this.getResourceAdapter(o);
                return resource == null ? false : UtilBase.this.isParentChild(roots, resource);
            }
        };
    }

    public ISelector selectBySourcePath() {
        return new ASelector(){
            Map selectorCache = new HashMap();

            ISelector getSelector(IResource resource) {
                IProject project = resource.getProject();
                ISelector selector = (ISelector)this.selectorCache.get(project);
                if (selector == null) {
                    selector = UtilBase.this.selectBySourcePath(project);
                    this.selectorCache.put(project, selector);
                }
                return selector;
            }

            public boolean select(Object o) {
                IResource resource = UtilBase.this.getResourceAdapter(o);
                return resource == null ? false : this.getSelector(resource).select((Object)resource);
            }
        };
    }

    public ISelector selectBySourcePath(IProject project) {
        return this.selectByPath();
    }

    public ISelector selectIfProject() {
        return new ASelector(){

            public boolean select(Object o) {
                IResource resource = UtilBase.this.getResourceAdapter(o);
                return resource == null ? false : resource instanceof IProject;
            }
        };
    }

    public ISelector selectOpenlSource() {
        return this.selectBySourcePath();
    }

    public void setResourceBundleName(String resourceBundleName) {
        this.resourceBundleName = resourceBundleName;
        this.resourceBundle = null;
    }

    public Throwable unwrapInvocationTargetException(InvocationTargetException t) {
        Throwable cause;
        while ((cause = t.getCause()) instanceof InvocationTargetException) {
            t = (InvocationTargetException)cause;
        }
        return cause != null ? cause : t;
    }
}

