/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.security;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UserDetailsService;
import org.openl.commons.web.util.WebTool;

public class LocalUserFilter
implements Filter {
    private UserDetailsService userDetailsService;
    private boolean autoLogin;
    private String[] ignoredUrls = new String[0];

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.autoLogin && WebTool.isLocalRequest((ServletRequest)request) && SecurityContextHolder.getContext().getAuthentication() == null && !this.isIgnoredRequest(request)) {
            UserDetails userDetails = this.userDetailsService.loadUserByUsername("LOCAL");
            UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)userDetails, null, userDetails.getAuthorities());
            SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
        }
        chain.doFilter(request, response);
    }

    public void init(FilterConfig ignored) throws ServletException {
    }

    protected boolean isIgnoredRequest(ServletRequest req) {
        HttpServletRequest request = (HttpServletRequest)req;
        String uri = request.getRequestURI();
        int queryParamIndex = uri.indexOf(63);
        if (queryParamIndex > 0) {
            uri = uri.substring(0, queryParamIndex);
        }
        for (String url : this.ignoredUrls) {
            if (!uri.endsWith(request.getContextPath() + url)) continue;
            return true;
        }
        return false;
    }

    public void setAutoLogin(boolean autoLogin) {
        this.autoLogin = autoLogin;
    }

    public void setIgnoredUrls(String[] ignoredUrls) {
        this.ignoredUrls = ignoredUrls;
    }

    public void setUserDetailsService(UserDetailsService userDetailsService) {
        this.userDetailsService = userDetailsService;
    }
}

