/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.security;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.acegisecurity.AccessDeniedException;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.InsufficientAuthenticationException;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.ui.AccessDeniedHandler;
import org.acegisecurity.ui.AccessDeniedHandlerImpl;
import org.acegisecurity.ui.ExceptionTranslationFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OpenLExceptionTranslationFilter
extends ExceptionTranslationFilter {
    private static final Log logger = LogFactory.getLog(OpenLExceptionTranslationFilter.class);
    private AccessDeniedHandler accessDeniedHandler = new AccessDeniedHandlerImpl();

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            super.doFilter(request, response, chain);
        }
        catch (ServletException e) {
            logger.debug((Object)"Exception in OpenLExceptionTranslationFilter", (Throwable)e);
            AccessDeniedException ade = this.extractAccessDeniedExeption(e.getRootCause(), 50);
            if (ade != null) {
                if (this.getAuthenticationTrustResolver().isAnonymous(SecurityContextHolder.getContext().getAuthentication())) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Access is denied (user is anonymous); redirecting to authentication entry point", (Throwable)e);
                    }
                    this.sendStartAuthentication(request, response, chain, (AuthenticationException)new InsufficientAuthenticationException("Full authentication is required to access this resource"));
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Access is denied (user is not anonymous); delegating to AccessDeniedHandler", (Throwable)e);
                    }
                    this.accessDeniedHandler.handle(request, response, ade);
                }
            }
            throw e;
        }
    }

    private AccessDeniedException extractAccessDeniedExeption(Throwable throwable, int depth) {
        if (throwable == null) {
            return null;
        }
        if (throwable instanceof AccessDeniedException) {
            return (AccessDeniedException)throwable;
        }
        Throwable cause = throwable.getCause();
        if (cause == null || cause == throwable || !(cause instanceof Exception) || depth == 0) {
            return null;
        }
        return this.extractAccessDeniedExeption(cause, depth - 1);
    }

    public void setAccessDeniedHandler(AccessDeniedHandler accessDeniedHandler) {
        super.setAccessDeniedHandler(accessDeniedHandler);
        this.accessDeniedHandler = accessDeniedHandler;
    }
}

