/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.security;

import org.acegisecurity.AccessDecisionManager;
import org.acegisecurity.AccessDeniedException;
import org.acegisecurity.ConfigAttribute;
import org.acegisecurity.ConfigAttributeDefinition;
import org.acegisecurity.SecurityConfig;
import org.acegisecurity.context.SecurityContextHolder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class SecurityUtils {
    private static final Log log = LogFactory.getLog(SecurityUtils.class);
    public static final String LOCAL_USER_ID = "LOCAL";
    private static AccessDecisionManager accessDecisionManager;

    public static void check(ConfigAttributeDefinition config) throws AccessDeniedException {
        accessDecisionManager.decide(SecurityContextHolder.getContext().getAuthentication(), null, config);
    }

    public static void check(String privilege) throws AccessDeniedException {
        ConfigAttributeDefinition cad = new ConfigAttributeDefinition();
        cad.addConfigAttribute((ConfigAttribute)new SecurityConfig(privilege));
        SecurityUtils.check(cad);
    }

    public static boolean isGranted(String privilege) {
        try {
            SecurityUtils.check(privilege);
        }
        catch (AccessDeniedException e) {
            return false;
        }
        return true;
    }

    public static void useAccessDecisionManager(AccessDecisionManager adm) {
        accessDecisionManager = adm;
    }

    public void setStaticAccessDecisionManager(AccessDecisionManager accessDecisionManager) {
        SecurityUtils.useAccessDecisionManager(accessDecisionManager);
    }
}

