/*
 * Decompiled with CFR 0.152.
 */
package org.openl.conf.ant;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.Stack;
import org.openl.ICompileContext;
import org.openl.IOpenBinder;
import org.openl.IOpenParser;
import org.openl.IOpenVM;
import org.openl.OpenL;
import org.openl.binding.ICastFactory;
import org.openl.binding.INameSpacedMethodFactory;
import org.openl.binding.INameSpacedTypeFactory;
import org.openl.binding.INameSpacedVarFactory;
import org.openl.binding.INodeBinderFactory;
import org.openl.binding.impl.Binder;
import org.openl.conf.BaseOpenLBuilder;
import org.openl.conf.IConfigurableResourceContext;
import org.openl.conf.IOpenLConfiguration;
import org.openl.conf.IUserContext;
import org.openl.conf.OpenConfigurationException;
import org.openl.conf.ant.AntHelper;
import org.openl.conf.ant.AntOpenLTask;
import org.openl.impl.DefaultCompileContext;
import org.openl.syntax.grammar.IGrammarFactory;
import org.openl.syntax.impl.Parser;
import org.openl.util.Log;
import org.openl.util.RuntimeExceptionWrapper;
import org.openl.vm.SimpleVM;

public class AntOpenLBuilder
extends BaseOpenLBuilder {
    public static UserContextStack userCxt = new UserContextStack();

    public static String getAntProjectConfigurationVariable(String openl) {
        return openl + ".configuration";
    }

    public static String getAntTarget(String openl) {
        return "build." + openl;
    }

    public OpenL build(String openl) throws OpenConfigurationException {
        OpenL op = new OpenL();
        boolean changedClassLoader = false;
        ClassLoader oldClassLoader = null;
        try {
            userCxt.push(this.getUserEnvironmentContext());
            ClassLoader myClassLoader = ((Object)((Object)this)).getClass().getClassLoader();
            oldClassLoader = Thread.currentThread().getContextClassLoader();
            if (oldClassLoader != myClassLoader) {
                Thread.currentThread().setContextClassLoader(myClassLoader);
                changedClassLoader = true;
            }
            new AntHelper(this.getAntFile(openl), AntOpenLBuilder.getAntTarget(openl), this.getProperties(openl));
            IOpenLConfiguration conf = AntOpenLTask.retrieveConfiguration();
            op.setParser((IOpenParser)new Parser((IGrammarFactory)conf));
            op.setBinder((IOpenBinder)new Binder((INodeBinderFactory)conf, (INameSpacedMethodFactory)conf, (ICastFactory)conf, (INameSpacedVarFactory)conf, (INameSpacedTypeFactory)conf, op));
            op.setVm((IOpenVM)new SimpleVM());
            op.setCompileContext(this.buildCompileContext());
            if (changedClassLoader) {
                Thread.currentThread().setContextClassLoader(oldClassLoader);
            }
            userCxt.pop();
        }
        catch (Exception ex) {
            try {
                throw RuntimeExceptionWrapper.wrap((Throwable)ex);
            }
            catch (Throwable throwable) {
                if (changedClassLoader) {
                    Thread.currentThread().setContextClassLoader(oldClassLoader);
                }
                userCxt.pop();
                throw throwable;
            }
        }
        return op;
    }

    protected String getAntFile(String openl) {
        File f;
        String name = this.getResourceContext().findProperty(openl + ".ant.build.file");
        if (name != null) {
            File f2 = this.getResourceContext().findFileSystemResource(name);
            if (f2 != null) {
                return f2.getAbsolutePath();
            }
            throw new OpenConfigurationException("File " + name + " is not found ", null, null);
        }
        name = openl + ".build.xml";
        if (name != null && (f = this.getResourceContext().findFileSystemResource(name)) != null) {
            return f.getAbsolutePath();
        }
        name = this.getResourceContext().findProperty("org.openl.default.ant.build.file");
        if (name != null) {
            f = this.getResourceContext().findFileSystemResource(name);
            if (f != null) {
                return f.getAbsolutePath();
            }
            throw new OpenConfigurationException("File " + name + " is not found ", null, null);
        }
        throw new OpenConfigurationException("Can not find Ant configuration file for " + openl, null, null);
    }

    private ICompileContext buildCompileContext() {
        String propertyValue;
        DefaultCompileContext compileContext = new DefaultCompileContext();
        IConfigurableResourceContext resourceContext = this.getResourceContext();
        if (resourceContext != null && (propertyValue = resourceContext.findProperty("validation")) != null) {
            Boolean value = Boolean.valueOf(propertyValue);
            compileContext.setValidationEnabled(value.booleanValue());
        }
        return compileContext;
    }

    protected Properties getProperties(String openl) {
        URL url = this.getResourceContext().findClassPathResource(openl.replace('.', '/') + '/' + openl + ".ant.properties");
        if (url == null) {
            return null;
        }
        InputStream is = null;
        try {
            is = url.openStream();
            Properties p = new Properties();
            p.load(is);
            Properties properties = p;
            return properties;
        }
        catch (IOException e) {
            throw RuntimeExceptionWrapper.wrap((Throwable)e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Throwable t) {
                Log.error((Object)"Error closing stream", (Throwable)t);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class UserContextStack
    extends ThreadLocal<Stack<IUserContext>> {
        UserContextStack() {
        }

        @Override
        protected Stack<IUserContext> initialValue() {
            return new Stack<IUserContext>();
        }

        public IUserContext pop() {
            return this.stack().pop();
        }

        public void push(IUserContext ucxt) {
            this.stack().push(ucxt);
        }

        protected Stack<IUserContext> stack() {
            return (Stack)this.get();
        }

        public IUserContext top() {
            return this.stack().peek();
        }
    }
}

