/*
 * Decompiled with CFR 0.152.
 */
package org.openl.conf.ant;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Task;
import org.openl.conf.ClassFactory;
import org.openl.conf.ClassLoaderFactory;
import org.openl.conf.ConfigurableResourceContext;
import org.openl.conf.IConfigurableResourceContext;
import org.openl.conf.IOpenFactoryConfiguration;
import org.openl.conf.IOpenLConfiguration;
import org.openl.conf.IUserContext;
import org.openl.conf.LibraryFactoryConfiguration;
import org.openl.conf.NodeBinderFactoryConfiguration;
import org.openl.conf.OpenConfigurationException;
import org.openl.conf.OpenFactoryConfiguration;
import org.openl.conf.OpenLConfiguration;
import org.openl.conf.TypeCastFactory;
import org.openl.conf.TypeFactoryConfiguration;
import org.openl.conf.UserContext;
import org.openl.conf.ant.AntOpenLBuilder;
import org.openl.syntax.grammar.IGrammar;

public class AntOpenLTask
extends Task {
    public static IOpenLConfiguration lastConfiguration;
    boolean shared = false;
    OpenLConfiguration conf = new OpenLConfiguration();
    String category;
    String classpath;
    String extendsCategory;

    static IOpenLConfiguration retrieveConfiguration() {
        if (lastConfiguration == null) {
            throw new NullPointerException();
        }
        IOpenLConfiguration ret = lastConfiguration;
        lastConfiguration = null;
        return ret;
    }

    public void addConfiguredTypeFactory(OpenFactoryConfiguration of) {
        this.conf.addOpenFactory((IOpenFactoryConfiguration)of);
    }

    public NodeBinderFactoryConfiguration createBindings() {
        NodeBinderFactoryConfiguration nbf = new NodeBinderFactoryConfiguration();
        this.conf.setBinderFactory(nbf);
        return nbf;
    }

    public ClassFactory createGrammar() {
        ClassFactory cf = new ClassFactory();
        cf.setExtendsClassName(IGrammar.class.getName());
        this.conf.setGrammarFactory(cf);
        return cf;
    }

    public LibraryFactoryConfiguration createLibraries() {
        LibraryFactoryConfiguration mf = new LibraryFactoryConfiguration();
        this.conf.setMethodFactory(mf);
        return mf;
    }

    public TypeCastFactory createTypecast() {
        TypeCastFactory tcf = new TypeCastFactory();
        this.conf.setTypeCastFactory(tcf);
        return tcf;
    }

    public TypeFactoryConfiguration createTypes() {
        TypeFactoryConfiguration mf = new TypeFactoryConfiguration();
        this.conf.setTypeFactory(mf);
        return mf;
    }

    public void execute() throws BuildException {
        try {
            if (this.category == null) {
                throw new OpenConfigurationException("The category must be set", this.getUri(), null);
            }
            IOpenLConfiguration existing = OpenLConfiguration.getInstance((String)this.category, (IUserContext)AntOpenLBuilder.userCxt.top());
            if (existing != null) {
                this.saveConfiguration(existing);
                return;
            }
            IOpenLConfiguration extendsConfiguration = null;
            if (this.extendsCategory != null && (extendsConfiguration = OpenLConfiguration.getInstance((String)this.extendsCategory, (IUserContext)AntOpenLBuilder.userCxt.top())) == null) {
                throw new OpenConfigurationException("The extended category " + this.extendsCategory + " must have been loaded first", this.getUri(), null);
            }
            IConfigurableResourceContext cxt = this.getConfigurationContext(extendsConfiguration);
            this.conf.setParent(extendsConfiguration);
            this.conf.setConfigurationContext(cxt);
            this.conf.validate(cxt);
            OpenLConfiguration.register((String)this.category, (IUserContext)AntOpenLBuilder.userCxt.top(), (IOpenLConfiguration)this.conf, (boolean)this.shared);
            this.saveConfiguration((IOpenLConfiguration)this.conf);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new BuildException((Throwable)e);
        }
    }

    public String getCategory() {
        return this.category;
    }

    IConfigurableResourceContext getConfigurationContext(IOpenLConfiguration extendsConfiguration) throws Exception {
        ClassLoader parentLoader;
        ClassLoader myClassLoader = parentLoader = extendsConfiguration == null ? ClassLoaderFactory.getOpenlCoreLoader(null) : extendsConfiguration.getConfigurationContext().getClassLoader();
        if (this.classpath != null && this.classpath.trim().length() != 0) {
            String baseDir = this.getProject().getBaseDir().getCanonicalPath();
            UserContext ucxt = new UserContext(null, baseDir);
            myClassLoader = ClassLoaderFactory.createUserClassloader((String)this.category, (String)this.classpath, (ClassLoader)parentLoader, (IUserContext)ucxt);
        } else {
            myClassLoader = AntOpenLBuilder.userCxt.top().getUserClassLoader();
        }
        return new ConfigurableResourceContext(myClassLoader, (IOpenLConfiguration)this.conf);
    }

    public String getExtendsCategory() {
        return this.extendsCategory;
    }

    public String getUri() {
        Location loc = this.getLocation();
        return loc == null ? null : loc.toString();
    }

    public boolean isShared() {
        return this.shared;
    }

    void saveConfiguration(IOpenLConfiguration conf) {
        lastConfiguration = conf;
    }

    public void setCategory(String string) {
        this.category = string;
    }

    public void setClasspath(String string) {
        this.classpath = string;
    }

    public void setExtendsCategory(String string) {
        this.extendsCategory = string;
    }

    public void setShared(boolean b) {
        this.shared = b;
    }
}

