/*
 * Decompiled with CFR 0.152.
 */
package org.openl.conf.ant;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FileSet;
import org.openl.util.FileTool;
import org.openl.util.Log;
import org.openl.util.StringTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClasspathCopy
extends Task {
    public static final String JAVA_CLASSPATH_PROPERTY = "java.class.path";
    public static final String COPY_WORKSPACE_MODE = "copy.workspace";
    public static final String COPY_WEBAPP_MODE = "copy.webapp";
    public static final String[] ALL_MODES = new String[]{"copy.workspace", "copy.webapp"};
    protected String startupFileName;
    private boolean copyTomcat = false;
    String copyMode = null;
    String targetDir = null;
    String defaultExclude = ".*apache.ant.*|.*javacc.*|.*junit.*";
    boolean validateThisDir;
    String projectDir = ".";
    String classpathExclude = null;
    String classpathInclude = null;
    String pathSeparator = File.pathSeparator;
    String classpath = null;

    public static String findApacheTomcatHome() throws IOException {
        String cpath = System.getProperty(JAVA_CLASSPATH_PROPERTY);
        String[] pathElements = StringTool.tokenize((String)cpath, (String)File.pathSeparator);
        for (int i = 0; i < pathElements.length; ++i) {
            if (!pathElements[i].endsWith("bootstrap.jar")) continue;
            File tomcatHome = new File(pathElements[i]).getCanonicalFile().getParentFile().getParentFile().getParentFile();
            return tomcatHome.toString();
        }
        throw new RuntimeException("Could not find bootstrap.jar in java.class.path");
    }

    static String printModes() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ALL_MODES.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(ALL_MODES[i]);
        }
        return sb.toString();
    }

    public void execute() throws BuildException {
        File wspaceDir;
        if (this.targetDir == null) {
            throw new BuildException("Attribute targetDir must be defined for ClasspathCopy");
        }
        if (this.copyMode == null) {
            throw new BuildException("Attribute copyMode must be defined for ClasspathCopy. Allowed modes: " + ClasspathCopy.printModes());
        }
        File projectFile = new File(this.projectDir);
        try {
            wspaceDir = projectFile.getCanonicalFile().getParentFile();
        }
        catch (IOException e1) {
            throw new BuildException((Throwable)e1);
        }
        String[] classpathElements = StringTool.tokenize((String)this.getClasspath(), (String)this.pathSeparator);
        String excludePattern = this.defaultExclude;
        if (this.classpathExclude != null) {
            excludePattern = excludePattern + "|" + this.classpathExclude;
        }
        CopyExecutor cp = this.makeCopyExecutor();
        ArrayList<File> cpath = new ArrayList<File>();
        for (int i = 0; i < classpathElements.length; ++i) {
            String element = classpathElements[i];
            if (element.matches(excludePattern)) {
                Log.info((Object)("Exclude " + element));
                continue;
            }
            try {
                File sourceFile = new File(element);
                File relativeFile = FileTool.buildRelativePath((File)wspaceDir, (File)sourceFile);
                if (sourceFile.isDirectory()) {
                    cp.copyDir(this.targetDir, wspaceDir, relativeFile);
                } else {
                    cp.copyFile(this.targetDir, wspaceDir, relativeFile);
                }
                if (!this.copyMode.equals(COPY_WORKSPACE_MODE)) continue;
                File relativePath = FileTool.buildRelativePath((File)projectFile, (File)sourceFile);
                cpath.add(relativePath);
                continue;
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e);
            }
        }
        if (this.copyTomcat) {
            File relativeFile;
            try {
                File sourceFile = new File(ClasspathCopy.findApacheTomcatHome());
                relativeFile = FileTool.buildRelativePath((File)wspaceDir, (File)sourceFile);
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e);
            }
            cp.copyDir(this.targetDir, wspaceDir, relativeFile);
        }
        if (this.startupFileName != null) {
            try {
                this.generateStartupFile(cpath);
            }
            catch (IOException e) {
                throw new BuildException("Error creating startup file: ", (Throwable)e);
            }
        }
    }

    private void generateStartupBatFile(List<File> path) throws IOException {
        String batFile = this.startupFileName;
        if (!batFile.endsWith(".bat") || !batFile.endsWith(".cmd")) {
            batFile = batFile + ".bat";
        }
        File startupFile = new File(this.targetDir + "/" + batFile);
        PrintWriter w = new PrintWriter(new FileWriter(startupFile));
        w.println("cd " + this.getProjectDirName());
        w.println("set CP=");
        for (File element : path) {
            w.println("set CP=%CP%" + element.getPath() + ";");
        }
        w.println();
        w.println("java -Xms256M -Xmx1024M -cp %CP% org.openl.rules.webstudio.util.StartTomcat");
        w.println("pause");
        w.close();
    }

    private void generateStartupFile(List<File> path) throws IOException {
        String targetPlatform = System.getProperty("os.name");
        if (targetPlatform.contains("Windows")) {
            this.generateStartupBatFile(path);
        } else {
            this.generateStartupUnixShellFile();
        }
    }

    private void generateStartupUnixShellFile() {
    }

    public String getClasspath() {
        if (this.classpath == null) {
            this.classpath = System.getProperty(JAVA_CLASSPATH_PROPERTY);
        }
        return this.classpath;
    }

    public String getClasspathExclude() {
        return this.classpathExclude;
    }

    public String getClasspathInclude() {
        return this.classpathInclude;
    }

    public String getCopyMode() {
        return this.copyMode;
    }

    Copy getCopyTask() {
        Copy cpy = new Copy();
        cpy.setProject(this.getProject());
        cpy.setPreserveLastModified(true);
        return cpy;
    }

    public String getDefaultExclude() {
        return this.defaultExclude;
    }

    public String getPathSeparator() {
        return this.pathSeparator;
    }

    public String getProjectDir() {
        return this.projectDir;
    }

    private String getProjectDirName() throws IOException {
        return new File(this.projectDir).getCanonicalFile().getName();
    }

    public String getStartupFileName() {
        return this.startupFileName;
    }

    public String getTargetDir() {
        return this.targetDir;
    }

    public boolean isCopyTomcat() {
        return this.copyTomcat;
    }

    public boolean isValidateThisDir() {
        return this.validateThisDir;
    }

    private CopyExecutor makeCopyExecutor() {
        if (this.copyMode.equals(COPY_WORKSPACE_MODE)) {
            return new CopyWorkspace();
        }
        if (this.copyMode.equals(COPY_WEBAPP_MODE)) {
            return new CopyWebapp();
        }
        throw new BuildException("Invalid Copy Mode: " + this.copyMode + ". Allowed modes: " + ClasspathCopy.printModes());
    }

    public void setClasspath(String classpath) {
        this.classpath = classpath;
    }

    public void setClasspathExclude(String classpathExclude) {
        this.classpathExclude = classpathExclude;
    }

    public void setClasspathInclude(String classpathInclude) {
        this.classpathInclude = classpathInclude;
    }

    public void setCopyMode(String copyMode) {
        this.copyMode = copyMode;
    }

    public void setCopyTomcat(boolean copyTomcatProject) {
        this.copyTomcat = copyTomcatProject;
    }

    public void setDefaultExclude(String defaultExclude) {
        this.defaultExclude = defaultExclude;
    }

    public void setPathSeparator(String pathSeparator) {
        this.pathSeparator = pathSeparator;
    }

    public void setProjectDir(String projectDir) {
        this.projectDir = projectDir;
    }

    public void setStartupFileName(String startupFile) {
        this.startupFileName = startupFile;
    }

    public void setTargetDir(String targetDir) {
        this.targetDir = targetDir;
    }

    public void setValidateThisDir(boolean validateThisDir) {
        this.validateThisDir = validateThisDir;
    }

    class CopyWorkspace
    extends CopyExecutor {
        CopyWorkspace() {
        }

        public void copyDir(String wspaceTargetDir, File wspaceSrcDir, File relativeFile) {
            Copy cpy = ClasspathCopy.this.getCopyTask();
            cpy.setTodir(new File(wspaceTargetDir + "/" + relativeFile.getPath()));
            FileSet fset = new FileSet();
            fset.setDir(new File(wspaceSrcDir + "/" + relativeFile.getPath()));
            cpy.addFileset(fset);
            cpy.setVerbose(true);
            cpy.execute();
        }

        public void copyFile(String wspaceTargetDir, File wspaceSrcDir, File relativeFile) {
            Copy cpy = ClasspathCopy.this.getCopyTask();
            cpy.setTofile(new File(wspaceTargetDir + "/" + relativeFile.getPath()));
            cpy.setFile(new File(wspaceSrcDir + "/" + relativeFile.getPath()));
            cpy.setVerbose(true);
            cpy.execute();
        }
    }

    class CopyWebapp
    extends CopyExecutor {
        CopyWebapp() {
        }

        public void copyDir(String webappTargetDir, File wspaceSrcDir, File relativeFile) {
            Copy cpy = ClasspathCopy.this.getCopyTask();
            cpy.setTodir(new File(webappTargetDir + "/WEB-INF/classes"));
            FileSet fset = new FileSet();
            fset.setDir(new File(wspaceSrcDir + "/" + relativeFile.getPath()));
            cpy.addFileset(fset);
            cpy.setVerbose(true);
            cpy.execute();
        }

        public void copyFile(String wspaceTargetDir, File wspaceSrcDir, File relativeFile) {
            Copy cpy = ClasspathCopy.this.getCopyTask();
            cpy.setTodir(new File(wspaceTargetDir + "/WEB-INF/lib"));
            cpy.setFile(new File(wspaceSrcDir + "/" + relativeFile.getPath()));
            cpy.setVerbose(true);
            cpy.execute();
        }
    }

    static abstract class CopyExecutor {
        CopyExecutor() {
        }

        public abstract void copyDir(String var1, File var2, File var3);

        public abstract void copyFile(String var1, File var2, File var3);
    }
}

