/*
 * Decompiled with CFR 0.152.
 */
package org.openl.conf.ant;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FileSet;
import org.openl.conf.ClassLoaderFactory;
import org.openl.conf.IUserContext;
import org.openl.conf.UserContext;
import org.openl.conf.ant.JavaWrapperGenerator;
import org.openl.exception.OpenLCompilationException;
import org.openl.impl.OpenClassJavaWrapper;
import org.openl.main.OpenLProjectPropertiesLoader;
import org.openl.main.OpenLWrapper;
import org.openl.message.OpenLErrorMessage;
import org.openl.message.OpenLMessage;
import org.openl.message.OpenLMessagesUtils;
import org.openl.message.Severity;
import org.openl.meta.IVocabulary;
import org.openl.rules.context.IRulesRuntimeContextConsumer;
import org.openl.rules.context.IRulesRuntimeContextProvider;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.impl.DomainOpenClass;
import org.openl.util.FileTool;
import org.openl.util.StringTool;
import org.openl.util.generation.SimpleBeanJavaGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaWrapperAntTask
extends Task {
    private static final String GOAL_MAKE_WRAPPER = "make wrapper";
    private static final String GOAL_UPDATE_PROPERTIES = "update properties";
    private static final String GOAL_MAKE_WEBINF = "make WEB-INF";
    private static final String GOAL_ALL = "all";
    private static final String GOAL_GENERATE_DATATYPES = "generate datatypes";
    private IOpenClass openClass;
    private String goal = "all";
    private String web_inf_path;
    private String web_inf_exclude = ".*apache.ant.*|.*apache.tomcat.*|.*javacc.*";
    private String web_inf_include = "";
    private String classpathExclude = ".*apache.ant.*|.*apache.commons.*|.*apache.tomcat.*|.*javacc.*";
    private String vocabularyClass;
    private String projectHome = ".";
    private boolean ignoreNonJavaTypes = false;
    private String ignoreFields;
    private String ignoreMethods;
    private String userClassPath;
    private String userHome = ".";
    private String deplUserHome;
    private String srcFile;
    private String deplSrcFile;
    private String srcModuleClass;
    private String openlName;
    private String targetSrcDir;
    private String targetClass;
    private String displayName;
    private String[] methods;
    private String[] fields;
    private String s_package;
    private String s_class;
    private String rulesFolder = "rules";
    private String extendsClass = null;
    private String classpathPropertiesOutputDir = ".";
    private String[] implementsInterfaces = new String[]{OpenLWrapper.class.getName(), IRulesRuntimeContextProvider.class.getName(), IRulesRuntimeContextConsumer.class.getName()};

    public void execute() throws BuildException {
        try {
            this.run();
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    private String filterClassPath() throws IOException {
        String cp = System.getProperty("java.class.path");
        String[] tokens = StringTool.tokenize((String)cp, (String)File.pathSeparator);
        StringBuffer buf = new StringBuffer(300);
        for (int i = 0; i < tokens.length; ++i) {
            if (tokens[i].matches(this.classpathExclude)) continue;
            File f = FileTool.buildRelativePath((File)new File(this.projectHome), (File)new File(tokens[i]));
            String relativePath = f.getPath().replace('\\', '/');
            buf.append(relativePath).append(File.pathSeparator);
        }
        return buf.toString();
    }

    public String getClasspathExclude() {
        return this.classpathExclude;
    }

    public String getClasspathPropertiesOutputDir() {
        return this.classpathPropertiesOutputDir;
    }

    public String getDeplSrcFile() {
        return this.deplSrcFile;
    }

    public String getDeplUserHome() {
        return this.deplUserHome;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getExtendsClass() {
        return this.extendsClass;
    }

    public String[] getFields() {
        return this.fields;
    }

    public String getGoal() {
        return this.goal;
    }

    public String getIgnoreFields() {
        return this.ignoreFields;
    }

    public String getIgnoreMethods() {
        return this.ignoreMethods;
    }

    public String[] getImplementsInterfaces() {
        return this.implementsInterfaces;
    }

    public String[] getMethods() {
        return this.methods;
    }

    public String getOpenlName() {
        return this.openlName;
    }

    private String getOutputFileName() {
        String file = this.targetSrcDir + "/" + this.targetClass.replace('.', '/') + ".java";
        return file;
    }

    public String getRulesFolder() {
        return this.rulesFolder;
    }

    public String getS_class() {
        return this.s_class;
    }

    public String getS_package() {
        return this.s_package;
    }

    public String getSrcFile() {
        return this.srcFile;
    }

    public String getSrcModuleClass() {
        return this.srcModuleClass;
    }

    public String getTargetClass() {
        return this.targetClass;
    }

    public String getTargetSrcDir() {
        return this.targetSrcDir;
    }

    public String getUserClassPath() {
        return this.userClassPath;
    }

    public String getUserHome() {
        return this.userHome;
    }

    public String getVocabularyClass() {
        return this.vocabularyClass;
    }

    public String getWeb_inf_exclude() {
        return this.web_inf_exclude;
    }

    public String getWeb_inf_include() {
        return this.web_inf_include;
    }

    public String getWeb_inf_path() {
        return this.web_inf_path;
    }

    public boolean isIgnoreNonJavaTypes() {
        return this.ignoreNonJavaTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IOpenClass makeOpenClass() throws Exception {
        UserContext ucxt = new UserContext(Thread.currentThread().getContextClassLoader(), this.userHome);
        if (this.userClassPath != null) {
            ClassLoader cl = ClassLoaderFactory.createClassLoader((String)this.userClassPath, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (IUserContext)ucxt);
            ucxt = new UserContext(cl, this.userHome);
            Thread.currentThread().setContextClassLoader(cl);
        }
        long start = System.currentTimeMillis();
        OpenClassJavaWrapper jwrapper = null;
        try {
            jwrapper = OpenClassJavaWrapper.createWrapper((String)this.openlName, (IUserContext)ucxt, (String)this.srcFile);
        }
        finally {
            long end = System.currentTimeMillis();
            System.out.println("Loaded " + this.srcFile + " in " + (end - start) + " ms");
        }
        List errorMessages = OpenLMessagesUtils.filterMessagesBySeverity((List)jwrapper.getCompiledClass().getMessages(), (Severity)Severity.ERROR);
        if (errorMessages != null && !errorMessages.isEmpty()) {
            String message = this.getErrorMessage(errorMessages);
            throw new OpenLCompilationException(message);
        }
        return jwrapper.getOpenClass();
    }

    private String getErrorMessage(List<OpenLMessage> errorMessages) {
        StringBuffer buf = new StringBuffer();
        buf.append("There are critical errors in wrapper:\n");
        for (int i = 0; i < errorMessages.size(); ++i) {
            if (errorMessages.get(i) instanceof OpenLErrorMessage) {
                OpenLErrorMessage openlError = (OpenLErrorMessage)errorMessages.get(i);
                buf.append(openlError.getError().toString());
                buf.append("\n\n");
                continue;
            }
            buf.append(String.format("[%s] %s", i + 1, errorMessages.get(i).getSummary()));
            buf.append("\n");
        }
        return buf.toString();
    }

    private void makeWebInfPath() {
        String targetFolder = this.web_inf_path;
        String classes_target = targetFolder + "/classes";
        String lib_target = targetFolder + "/lib";
        String cp = System.getProperty("java.class.path");
        String[] tokens = StringTool.tokenize((String)cp, (String)File.pathSeparator);
        System.out.println("Making WEB-INF...");
        for (int i = 0; i < tokens.length; ++i) {
            Copy cpy;
            if (tokens[i].matches(this.web_inf_exclude) && !tokens[i].matches(this.web_inf_include)) continue;
            System.out.println(tokens[i]);
            File f = new File(tokens[i]);
            if (f.isDirectory()) {
                cpy = new Copy();
                cpy.setProject(this.getProject());
                cpy.setTodir(new File(classes_target));
                FileSet fset = new FileSet();
                fset.setDir(f);
                cpy.addFileset(fset);
                cpy.setVerbose(true);
                cpy.execute();
                continue;
            }
            cpy = new Copy();
            cpy.setProject(this.getProject());
            cpy.setTodir(new File(lib_target));
            cpy.setFile(f);
            cpy.setVerbose(true);
            cpy.execute();
        }
    }

    private void run() throws Exception {
        if (this.ignoreFields != null) {
            this.fields = StringTool.tokenize((String)this.ignoreFields, (String)", ");
        }
        if (this.ignoreMethods != null) {
            this.methods = StringTool.tokenize((String)this.ignoreMethods, (String)", ");
        }
        if (this.goal.equals(GOAL_ALL) || this.goal.contains(GOAL_UPDATE_PROPERTIES)) {
            this.saveProjectProperties();
        }
        if (this.goal.equals(GOAL_ALL) || this.goal.contains(GOAL_MAKE_WRAPPER)) {
            this.openClass = this.makeOpenClass();
            JavaWrapperGenerator javaGenerator = new JavaWrapperGenerator(this.getTargetClass(), this.getExtendsClass(), this.getImplementsInterfaces(), this.getOpenlName(), this.getDeplSrcFile(), this.getSrcFile(), this.getSrcModuleClass(), this.getUserHome(), this.getDeplUserHome(), this.getRulesFolder(), this.getFields(), this.getMethods(), this.isIgnoreNonJavaTypes());
            String content = javaGenerator.generateJavaClass(this.openClass);
            String fileName = this.getOutputFileName();
            this.writeContentToFile(content, fileName);
        }
        if (this.goal.equals(GOAL_ALL) || this.goal.contains(GOAL_GENERATE_DATATYPES)) {
            this.writeDatatypeBeans(this.openClass.getTypes());
        }
        if (this.goal.contains(GOAL_MAKE_WEBINF) && this.web_inf_path == null) {
            throw new RuntimeException("web_inf_path is not set");
        }
        if (this.goal.equals(GOAL_ALL) || this.goal.contains(GOAL_MAKE_WRAPPER)) {
            if (this.web_inf_path == null) {
                return;
            }
            this.makeWebInfPath();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeContentToFile(String content, String fileName) throws IOException {
        OutputStreamWriter fw = null;
        try {
            new File(fileName).getParentFile().mkdirs();
            fw = new FileWriter(fileName);
            fw.write(content);
        }
        finally {
            if (fw != null) {
                fw.close();
            }
        }
    }

    private void writeDatatypeBeans(Map<String, IOpenClass> types) throws Exception {
        if (types != null) {
            for (Map.Entry<String, IOpenClass> datatype : types.entrySet()) {
                IOpenClass datatypeOpenClass = datatype.getValue();
                if (datatypeOpenClass instanceof DomainOpenClass) continue;
                Class datatypeClass = datatypeOpenClass.getInstanceClass();
                SimpleBeanJavaGenerator beanJavaGenerator = new SimpleBeanJavaGenerator(datatypeClass, this.getFieldsDescription(datatypeOpenClass.getDeclaredFields()), this.getFieldsDescription(datatypeOpenClass.getFields()));
                String javaClass = beanJavaGenerator.generateJavaClass();
                String fileName = this.targetSrcDir + "/" + datatypeClass.getName().replace('.', '/') + ".java";
                this.writeContentToFile(javaClass, fileName);
            }
        }
    }

    private Map<String, Class<?>> getFieldsDescription(Map<String, IOpenField> fields) {
        LinkedHashMap fieldsDescriprtion = new LinkedHashMap();
        for (Map.Entry<String, IOpenField> field : fields.entrySet()) {
            if (field.getValue().isStatic()) continue;
            fieldsDescriprtion.put(field.getKey(), field.getValue().getType().getInstanceClass());
        }
        return fieldsDescriprtion;
    }

    private void saveProjectProperties() throws IOException {
        Properties p = new Properties();
        p.put("openl.project.classpath", this.filterClassPath());
        p.put("openl.project.classpath.separator", File.pathSeparator);
        if (this.displayName != null) {
            p.put(this.targetClass + ".display.name", this.displayName);
        }
        if (this.vocabularyClass != null) {
            try {
                Class<?> c = Class.forName(this.vocabularyClass);
                Object instance = c.newInstance();
                IVocabulary vocabulary = (IVocabulary)instance;
            }
            catch (Throwable t) {
                System.err.println("Error occured while trying instantiate vocabulary class:" + this.vocabularyClass);
                t.printStackTrace();
            }
            p.put(this.targetClass + ".vocabulary.clazz", this.vocabularyClass);
        }
        new OpenLProjectPropertiesLoader().saveProperties(this.classpathPropertiesOutputDir, p, false);
    }

    public void setClasspathExclude(String classpathExclude) {
        this.classpathExclude = classpathExclude;
    }

    public void setClasspathPropertiesOutputDir(String classpathPropertiesOutputDir) {
        this.classpathPropertiesOutputDir = classpathPropertiesOutputDir;
    }

    public void setDeplSrcFile(String deplSrcFile) {
        this.deplSrcFile = deplSrcFile;
    }

    public void setDeplUserHome(String deplUserHome) {
        this.deplUserHome = deplUserHome;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setExtendsClass(String extendsClass) {
        this.extendsClass = extendsClass;
    }

    public void setFields(String[] fields) {
        this.fields = fields;
    }

    public void setGoal(String goal) {
        this.goal = goal;
    }

    public void setIgnoreFields(String ignoreFields) {
        this.ignoreFields = ignoreFields;
    }

    public void setIgnoreMethods(String ignoreMethods) {
        this.ignoreMethods = ignoreMethods;
    }

    public void setIgnoreNonJavaTypes(boolean ignoreNonJavaTypes) {
        this.ignoreNonJavaTypes = ignoreNonJavaTypes;
    }

    public void setImplementsInterfaces(String[] implementsInterfaces) {
        ArrayList<String> interfaces = new ArrayList<String>(Arrays.asList(this.implementsInterfaces));
        interfaces.addAll(Arrays.asList(implementsInterfaces));
        this.implementsInterfaces = interfaces.toArray(new String[interfaces.size()]);
    }

    public void setMethods(String[] methods) {
        this.methods = methods;
    }

    public void setOpenlName(String openlName) {
        this.openlName = openlName;
    }

    public void setRulesFolder(String rulesFolder) {
        this.rulesFolder = rulesFolder;
    }

    public void setS_class(String s_class) {
        this.s_class = s_class;
    }

    public void setS_package(String s_package) {
        this.s_package = s_package;
    }

    public void setSrcFile(String srcFile) {
        this.srcFile = srcFile;
    }

    public void setSrcModuleClass(String srcModuleClass) {
        this.srcModuleClass = srcModuleClass;
    }

    public void setTargetClass(String targetClass) {
        this.targetClass = targetClass;
    }

    public void setTargetSrcDir(String targetSrcDir) {
        this.targetSrcDir = targetSrcDir;
    }

    public void setUserClassPath(String userClassPath) {
        this.userClassPath = userClassPath;
    }

    public void setUserHome(String userHome) {
        this.userHome = userHome;
    }

    public void setVocabularyClass(String vocabularyClass) {
        this.vocabularyClass = vocabularyClass;
    }

    public void setWeb_inf_exclude(String web_inf_exclude) {
        this.web_inf_exclude = web_inf_exclude;
    }

    public void setWeb_inf_include(String web_inf_include) {
        this.web_inf_include = web_inf_include;
    }

    public void setWeb_inf_path(String web_inf_path) {
        this.web_inf_path = web_inf_path;
    }
}

